package ru.yandex.direct.core.entity.internalads.repository;

import java.util.List;
import java.util.function.Function;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.internalads.model.BannerUnreachableUrl;
import ru.yandex.direct.core.entity.internalads.ytmodels.generated.YtBannersUnreachableUrl;
import ru.yandex.direct.core.entity.internalads.ytmodels.generated.YtBannersUnreachableUrlRow;
import ru.yandex.direct.env.Environment;
import ru.yandex.direct.utils.FunctionalUtils;
import ru.yandex.direct.ytwrapper.client.YtExecutionUtil;
import ru.yandex.direct.ytwrapper.client.YtProvider;
import ru.yandex.direct.ytwrapper.model.YtCluster;

import static ru.yandex.direct.core.entity.internalads.ytmodels.generated.YtDbTables.BANNERSUNREACHABLEURL;

@Repository
@ParametersAreNonnullByDefault
public class BannersUnreachableUrlYtRepository {
    public static final String IDS_SPLITTER = ", ";
    private static final YtBannersUnreachableUrl BANNERSUNREACHABLEURL_TEST =
            new YtBannersUnreachableUrl("//home/yabs/banana/test/WrongDirectLinks");

    private final YtProvider ytProvider;
    private final InternalYaBsClusterChooser clusterChooser;
    private final YtBannersUnreachableUrl bannersUnreachableUrlTable;

    public BannersUnreachableUrlYtRepository(YtProvider ytProvider, InternalYaBsClusterChooser clusterChooser) {
        this.ytProvider = ytProvider;
        this.clusterChooser = clusterChooser;
        bannersUnreachableUrlTable = Environment.getCached().isProduction() ? BANNERSUNREACHABLEURL : BANNERSUNREACHABLEURL_TEST;
    }

    /**
     * Получить все записи таблицы yt-таблицы WrongDirectLinks, экспортируемой из БК
     */
    public List<BannerUnreachableUrl> getAll() {
        //TODO второй кластер добавим тут: https://st.yandex-team.ru/DIRECT-141536
        //List<YtCluster> clustersByPriority = clusterChooser.getAvailableClustersOrdered();
        List<YtCluster> clustersByPriority = List.of(YtCluster.HAHN);
        List<List<BannerUnreachableUrl>> bannersUnreachableUrl = YtExecutionUtil.executeWithFallback(clustersByPriority,
                ytProvider::getOperator,
                operator -> operator.readTableAndMap(
                        bannersUnreachableUrlTable,
                        new YtBannersUnreachableUrlRow(),
                        BannersUnreachableUrlYtRepository::convertFromYt
                )
        );
        return FunctionalUtils.flatMap(bannersUnreachableUrl, Function.identity());
    }

    /**
     * Для каждого баннера в строке создается отдельная модель
     * @param row строка Yt-таблицы, в которой с одним урлом ассоциированы баннеры, имеющие этот урл
     * @return Список баннеров из этой строки
     */
    private static List<BannerUnreachableUrl> convertFromYt(YtBannersUnreachableUrlRow row) {
        return StreamEx.split(row.getBannerDirectID(), IDS_SPLITTER)
                .map(Long::parseLong)
                .map(id -> createBannerUnreachableUrl(id, row.getLink(), row.getReason()))
                .toList();
    }

    public static BannerUnreachableUrl createBannerUnreachableUrl(Long id, String url, String reason) {
        return new BannerUnreachableUrl()
                .withId(id)
                .withUrl(url)
                .withReason(reason);
    }

}
