package ru.yandex.direct.core.entity.internalads.repository;

import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.dbschema.ppc.tables.records.InternalAdManagerPlaceAccessRecord;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;

import static ru.yandex.direct.dbschema.ppc.tables.InternalAdManagerPlaceAccess.INTERNAL_AD_MANAGER_PLACE_ACCESS;

@ParametersAreNonnullByDefault
@Repository
public class InternalAdsManagerProductAccessRepository {
    private final DslContextProvider dslContextProvider;

    public InternalAdsManagerProductAccessRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
    }

    public void savePlaces(DSLContext dslContext, Long relationId, @Nullable Set<Long> placeIds) {
        if (placeIds != null) {
            InsertHelper<InternalAdManagerPlaceAccessRecord> helper =
                    new InsertHelper<>(dslContext, INTERNAL_AD_MANAGER_PLACE_ACCESS);

            for (Long placeId : placeIds) {
                helper
                        .set(INTERNAL_AD_MANAGER_PLACE_ACCESS.RELATION_ID, relationId)
                        .set(INTERNAL_AD_MANAGER_PLACE_ACCESS.PLACE_ID, placeId)
                        .newRecord();
            }

            helper.execute();
        }
    }

    public void cleanUpPlaces(DSLContext dslContext, List<Long> relationIds) {
        dslContext.deleteFrom(INTERNAL_AD_MANAGER_PLACE_ACCESS)
                .where(INTERNAL_AD_MANAGER_PLACE_ACCESS.RELATION_ID.in(relationIds))
                .execute();
    }

    public Set<Long> getAccessiblePlaceIds(int shard, Long relationId) {
        return dslContextProvider.ppc(shard).select(INTERNAL_AD_MANAGER_PLACE_ACCESS.PLACE_ID)
                .from(INTERNAL_AD_MANAGER_PLACE_ACCESS)
                .where(INTERNAL_AD_MANAGER_PLACE_ACCESS.RELATION_ID.eq(relationId))
                .fetchSet(INTERNAL_AD_MANAGER_PLACE_ACCESS.PLACE_ID);
    }

    public Map<Long, List<Long>> getPlaceIdsForMultipleRelations(int shard, List<Long> relationIds) {
        return dslContextProvider.ppc(shard)
                .select(INTERNAL_AD_MANAGER_PLACE_ACCESS.RELATION_ID, INTERNAL_AD_MANAGER_PLACE_ACCESS.PLACE_ID)
                .from(INTERNAL_AD_MANAGER_PLACE_ACCESS)
                .where(INTERNAL_AD_MANAGER_PLACE_ACCESS.RELATION_ID.in(relationIds))
                .fetchGroups(INTERNAL_AD_MANAGER_PLACE_ACCESS.RELATION_ID, INTERNAL_AD_MANAGER_PLACE_ACCESS.PLACE_ID);
    }
}
