package ru.yandex.direct.core.entity.internalads.repository;

import java.util.Collection;
import java.util.stream.Collectors;

import org.springframework.stereotype.Component;

import ru.yandex.direct.config.DirectConfig;
import ru.yandex.direct.ytwrapper.model.YtCluster;

@Component
public class InternalYaBsClusterConfig {
    private final DirectConfig config;

    public InternalYaBsClusterConfig(DirectConfig config) {
        this.config = config.getBranch("internal-ads");
    }

    public Collection<YtCluster> getClusters() {
        return config.getStringList("yabs-clusters").stream()
                .map(YtCluster::parse)
                .collect(Collectors.toSet());
    }
}
