package ru.yandex.direct.core.entity.internalads.repository;

import java.util.List;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.internalads.model.InternalAdPlace;
import ru.yandex.direct.core.entity.internalads.ytmodels.generated.YtDbTables;
import ru.yandex.direct.core.entity.internalads.ytmodels.generated.YtPlaceRow;
import ru.yandex.direct.ytwrapper.client.YtExecutionUtil;
import ru.yandex.direct.ytwrapper.client.YtProvider;
import ru.yandex.direct.ytwrapper.model.YtCluster;

import static ru.yandex.direct.core.entity.internalads.ytmodels.generated.YtDbTables.PLACE;

@ParametersAreNonnullByDefault
@Repository
public class PlacesYtRepository {
    private final YtProvider ytProvider;
    private final InternalYaBsClusterChooser clusterChooser;

    public PlacesYtRepository(YtProvider ytProvider, InternalYaBsClusterChooser clusterChooser) {
        this.ytProvider = ytProvider;
        this.clusterChooser = clusterChooser;
    }

    /**
     * Получить все записи таблицы Place из yt-таблицы, экспортируемой из БК
     */
    public List<InternalAdPlace> getAll() {
        List<YtCluster> clustersByPriority = clusterChooser.getAvailableClustersOrdered();
        return YtExecutionUtil.executeWithFallback(clustersByPriority,
                ytProvider::getOperator,
                operator -> operator.readTableAndMap(PLACE, new YtPlaceRow(), PlacesYtRepository::convertFromYt));
    }

    private static InternalAdPlace convertFromYt(YtPlaceRow row) {
        return new InternalAdPlace()
                .withId(row.getPlaceID())
                .withParentId(row.getPlaceParentID())
                .withDescription(row.getPlaceDescription());
    }

    /**
     * Получить время последнего обновления данных для таблицы {@link YtDbTables#PLACE}
     * Время последнего обновления хранится в атрибуте таблицы {@link InternalYaBsClusterChooser#MAX_UNIX_TIME}
     * Считаем, что атрибут проставлен и имеет корректное значение, иначе упадем при определении свежести кластера {@link InternalYaBsClusterChooser}
     */
    @Nonnull
    public Long getLastUpdateUnixTime() {
        List<YtCluster> clustersByPriority = clusterChooser.getAvailableClustersOrdered();
        return YtExecutionUtil.executeWithFallback(clustersByPriority,
                ytProvider::getOperator,
                operator -> operator.readTableNumericAttribute(PLACE, InternalYaBsClusterChooser.MAX_UNIX_TIME));
    }

}
