package ru.yandex.direct.core.entity.internalads.repository;

import java.util.List;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.internalads.model.TemplatePlace;
import ru.yandex.direct.core.entity.internalads.ytmodels.generated.YtDbTables;
import ru.yandex.direct.core.entity.internalads.ytmodels.generated.YtTemplatePlaceRow;
import ru.yandex.direct.ytwrapper.client.YtExecutionUtil;
import ru.yandex.direct.ytwrapper.client.YtProvider;
import ru.yandex.direct.ytwrapper.model.YtCluster;

import static ru.yandex.direct.core.entity.internalads.ytmodels.generated.YtDbTables.TEMPLATEPLACE;

@Repository
@ParametersAreNonnullByDefault
public class TemplatePlaceYtRepository {
    private final YtProvider ytProvider;
    private final InternalYaBsClusterChooser clusterChooser;

    public TemplatePlaceYtRepository(YtProvider ytProvider, InternalYaBsClusterChooser clusterChooser) {
        this.ytProvider = ytProvider;
        this.clusterChooser = clusterChooser;
    }

    /**
     * Получить все записи таблицы TemplatePlace из yt-таблицы, экспортируемой из БК
     */
    public List<TemplatePlace> getAll() {
        List<YtCluster> clustersByPriority = clusterChooser.getAvailableClustersOrdered();
        return YtExecutionUtil.executeWithFallback(clustersByPriority,
                ytProvider::getOperator,
                operator -> operator.readTableAndMap(TEMPLATEPLACE, new YtTemplatePlaceRow(), this::convertFromYt));
    }

    /**
     * Получить время последнего обновления данных для таблицы {@link YtDbTables#TEMPLATEPLACE}
     * Время последнего обновления храниться в атрибуте таблицы {@link InternalYaBsClusterChooser#MAX_UNIX_TIME}
     * Считаем, что атрибут проставлен и имеет корректное значение, иначе упадем при определении свежести кластера {@link InternalYaBsClusterChooser}
     */
    @Nonnull
    public Long getLastUpdateUnixTime() {
        List<YtCluster> clustersByPriority = clusterChooser.getAvailableClustersOrdered();
        return YtExecutionUtil.executeWithFallback(clustersByPriority,
                ytProvider::getOperator,
                operator -> operator.readTableNumericAttribute(TEMPLATEPLACE, InternalYaBsClusterChooser.MAX_UNIX_TIME));
    }

    private TemplatePlace convertFromYt(YtTemplatePlaceRow row) {
        return new TemplatePlace()
                .withPlaceId(row.getPlaceID())
                .withTemplateId(row.getTemplateID());
    }
}
