package ru.yandex.direct.core.entity.internalads.restriction;

import java.util.Set;
import java.util.function.BiPredicate;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.banner.model.ImageSize;
import ru.yandex.direct.core.entity.image.model.BannerImageFormat;
import ru.yandex.direct.core.entity.internalads.restriction.InternalAdRestrictionDefects.ImageDimensionParam;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectId;

import static com.google.common.base.Preconditions.checkArgument;

@ParametersAreNonnullByDefault
abstract class AbstractRestrictionImageDimensions extends AbstractRestrictionImage {

    private final Integer width;
    private final Integer height;

    AbstractRestrictionImageDimensions(boolean isStrict, Integer width, Integer height,
                                       @Nullable Set<RestrictionImageFormat> formatsForCheck) {
        super(isStrict, formatsForCheck);
        //noinspection ConstantConditions
        checkArgument(width != null || height != null);
        this.width = width;
        this.height = height;
    }

    public Integer getWidth() {
        return width;
    }

    public Integer getHeight() {
        return height;
    }

    @Override
    public abstract DefectId<ImageDimensionParam> getDefectId();

    abstract BiPredicate<Integer, Integer> dimensionsPredicate();

    @Nullable
    @Override
    Defect checkRestriction(BannerImageFormat bannerImageFormat) {
        ImageSize imageSize = bannerImageFormat.getSize();

        if (width != null && !dimensionsPredicate().test(width, imageSize.getWidth())) {
            return imageSizeWrong(width, height);
        }

        if (height != null && !dimensionsPredicate().test(height, imageSize.getHeight())) {
            return imageSizeWrong(width, height);
        }

        return null;
    }

    private Defect<ImageDimensionParam> imageSizeWrong(Integer width, Integer height) {
        return new Defect<>(getDefectId(), new ImageDimensionParam(width, height));
    }

}
