package ru.yandex.direct.core.entity.internalads.restriction;

import java.util.Objects;
import java.util.Set;

import ru.yandex.direct.validation.result.DefectId;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkNotNull;

public class InternalAdRestrictionDefects {
    public enum Gen implements DefectId<Void> {
        FORMAT_INVALID
    }

    public enum Length implements DefectId<TextLengthParam> {
        TEXT_TOO_LONG,
        TEXT_TOO_SHORT,
    }

    public enum Text implements DefectId<Void> {
        TEXT_HAS_SPACES_AROUND,
    }

    public enum ImageSize implements DefectId<ImageSizeKbParam> {
        IMAGE_SIZE_KB_TOO_BIG,
    }

    public enum ImageFormat implements DefectId<ImageFormatParam> {
        IMAGE_FORMAT_INVALID,
    }

    public enum ImageDimension implements DefectId<ImageDimensionParam> {
        IMAGE_DIMENSION_NOT_EQUAL,
        IMAGE_DIMENSION_NOT_SQUARE,
        IMAGE_DIMENSION_TOO_BIG,
        IMAGE_DIMENSION_TOO_SMALL,
    }

    public enum Url implements DefectId<UrlCorrectParam> {
        URL_NOT_VALID,
    }

    public enum UrlWithSpaces implements DefectId<Void> {
        URL_HAS_SPACES,
    }

    public static class TextLengthParam {
        private final Integer minLength;
        private final Integer maxLength;

        TextLengthParam(Integer minLength, Integer maxLength) {
            checkArgument(minLength != null || maxLength != null);
            this.minLength = minLength;
            this.maxLength = maxLength;
        }

        public Integer getMinLength() {
            return minLength;
        }

        public Integer getMaxLength() {
            return maxLength;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            TextLengthParam that = (TextLengthParam) o;
            return Objects.equals(minLength, that.minLength) &&
                    Objects.equals(maxLength, that.maxLength);
        }

        @Override
        public int hashCode() {
            return Objects.hash(minLength, maxLength);
        }
    }

    public static class ImageFormatParam {
        private final Set<String> formats;

        ImageFormatParam(Set<String> formats) {
            this.formats = checkNotNull(formats);
        }

        public Set<String> getFormats() {
            return formats;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            ImageFormatParam that = (ImageFormatParam) o;
            return formats.equals(that.formats);
        }

        @Override
        public int hashCode() {
            return Objects.hash(formats);
        }
    }

    public static class ImageSizeKbParam {
        private final int maxSizeKb;

        ImageSizeKbParam(int maxSizeKb) {
            this.maxSizeKb = maxSizeKb;
        }

        public int getMaxSizeKb() {
            return maxSizeKb;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            ImageSizeKbParam that = (ImageSizeKbParam) o;
            return maxSizeKb == that.maxSizeKb;
        }

        @Override
        public int hashCode() {
            return Objects.hash(maxSizeKb);
        }
    }

    public static class ImageDimensionParam {
        private final Integer width;
        private final Integer height;

        ImageDimensionParam(Integer width, Integer height) {
            this.width = width;
            this.height = height;
        }

        public Integer getWidth() {
            return width;
        }

        public Integer getHeight() {
            return height;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            ImageDimensionParam that = (ImageDimensionParam) o;
            return Objects.equals(width, that.width) &&
                    Objects.equals(height, that.height);
        }

        @Override
        public int hashCode() {
            return Objects.hash(width, height);
        }
    }

    public static class UrlCorrectParam {
        private final boolean isHttpsOnly;

        UrlCorrectParam(boolean isHttpsOnly) {
            this.isHttpsOnly = isHttpsOnly;
        }

        public boolean isHttpsOnly() {
            return isHttpsOnly;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            UrlCorrectParam that = (UrlCorrectParam) o;
            return isHttpsOnly == that.isHttpsOnly;
        }

        @Override
        public int hashCode() {
            return Objects.hash(isHttpsOnly);
        }
    }
}
