package ru.yandex.direct.core.entity.internalads.restriction;

import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;

import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.internalads.restriction.InternalAdRestrictionDefects.ImageDimensionParam;
import ru.yandex.direct.validation.result.DefectId;

public class RestrictionImageDimensionsEq extends AbstractRestrictionImageDimensions {

    RestrictionImageDimensionsEq(boolean isStrict, Integer width, Integer height,
                                 @Nullable Set<RestrictionImageFormat> formatsForCheck) {
        super(isStrict, width, height, formatsForCheck);
    }

    @Override
    public DefectId<ImageDimensionParam> getDefectId() {
        return InternalAdRestrictionDefects.ImageDimension.IMAGE_DIMENSION_NOT_EQUAL;
    }

    @Override
    BiPredicate<Integer, Integer> dimensionsPredicate() {
        return Objects::equals;
    }
}
