package ru.yandex.direct.core.entity.internalads.restriction;

import java.util.Set;
import java.util.function.BiPredicate;

import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.internalads.restriction.InternalAdRestrictionDefects.ImageDimensionParam;
import ru.yandex.direct.validation.result.DefectId;

public class RestrictionImageDimensionsMin extends AbstractRestrictionImageDimensions {

    RestrictionImageDimensionsMin(boolean isStrict, Integer width, Integer height,
                                  @Nullable Set<RestrictionImageFormat> formatsForCheck) {
        super(isStrict, width, height, formatsForCheck);
    }

    @Override
    public DefectId<ImageDimensionParam> getDefectId() {
        return InternalAdRestrictionDefects.ImageDimension.IMAGE_DIMENSION_TOO_SMALL;
    }

    @Override
    BiPredicate<Integer, Integer> dimensionsPredicate() {
        return (dimensionMin, dimensionValue) -> dimensionMin.compareTo(dimensionValue) <= 0;
    }
}
