package ru.yandex.direct.core.entity.internalads.restriction;

import java.util.Objects;
import java.util.Set;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.banner.model.ImageSize;
import ru.yandex.direct.core.entity.image.model.BannerImageFormat;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectId;

@ParametersAreNonnullByDefault
public class RestrictionImageDimensionsSquare extends AbstractRestrictionImage {

    RestrictionImageDimensionsSquare(boolean isStrict, @Nullable Set<RestrictionImageFormat> formatsForCheck) {
        super(isStrict, formatsForCheck);
    }

    @Override
    public DefectId<InternalAdRestrictionDefects.ImageDimensionParam> getDefectId() {
        return InternalAdRestrictionDefects.ImageDimension.IMAGE_DIMENSION_NOT_SQUARE;
    }

    @Nullable
    @Override
    Defect checkRestriction(BannerImageFormat bannerImageFormat) {
        ImageSize imageSize = bannerImageFormat.getSize();
        if (!Objects.equals(imageSize.getWidth(), imageSize.getHeight())) {
            return imageSizeWrong(imageSize.getWidth(), imageSize.getHeight());
        }

        return null;
    }

    private Defect<InternalAdRestrictionDefects.ImageDimensionParam> imageSizeWrong(Integer width, Integer height) {
        return new Defect<>(getDefectId(), new InternalAdRestrictionDefects.ImageDimensionParam(width, height));
    }

}
