package ru.yandex.direct.core.entity.internalads.restriction;

import java.util.Optional;
import java.util.Set;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.image.model.BannerImageFormat;
import ru.yandex.direct.core.entity.internalads.restriction.InternalAdRestrictionDefects.ImageFormatParam;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectId;

import static com.google.common.base.Preconditions.checkArgument;
import static ru.yandex.direct.utils.FunctionalUtils.listToSet;

@ParametersAreNonnullByDefault
public class RestrictionImageFormatIn extends AbstractRestrictionImage {

    private final Set<RestrictionImageFormat> formats;

    RestrictionImageFormatIn(boolean isStrict, Set<RestrictionImageFormat> formats) {
        super(isStrict, null);
        //noinspection ConstantConditions
        checkArgument(formats != null);
        this.formats = formats;
    }

    public Set<RestrictionImageFormat> getFormats() {
        return formats;
    }

    @Override
    public DefectId<ImageFormatParam> getDefectId() {
        return InternalAdRestrictionDefects.ImageFormat.IMAGE_FORMAT_INVALID;
    }

    @Nullable
    @Override
    Defect checkRestriction(BannerImageFormat bannerImageFormat) {
        Optional<RestrictionImageFormat> origFormat = getImageOrigFormat(bannerImageFormat);
        if (origFormat.isEmpty() || !formats.contains(origFormat.get())) {
            Set<String> strFormats = listToSet(formats, RestrictionImageFormat::getMdsFormat);
            return new Defect<>(getDefectId(), new ImageFormatParam(strFormats));
        }

        return null;
    }

}
