package ru.yandex.direct.core.entity.internalads.restriction;

import java.util.Set;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.image.converter.BannerImageConverter;
import ru.yandex.direct.core.entity.image.model.BannerImageFormat;
import ru.yandex.direct.core.entity.image.model.ImageMdsMeta;
import ru.yandex.direct.core.entity.internalads.restriction.InternalAdRestrictionDefects.ImageSizeKbParam;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectId;

@ParametersAreNonnullByDefault
public class RestrictionImageSizeKbMax extends AbstractRestrictionImage {

    private final int size;

    RestrictionImageSizeKbMax(boolean isStrict, int size, @Nullable Set<RestrictionImageFormat> formatsForCheck) {
        super(isStrict, formatsForCheck);
        this.size = size;
    }

    public int getSize() {
        return size;
    }

    @Override
    public DefectId<ImageSizeKbParam> getDefectId() {
        return InternalAdRestrictionDefects.ImageSize.IMAGE_SIZE_KB_TOO_BIG;
    }

    @Nullable
    @Override
    Defect checkRestriction(BannerImageFormat bannerImageFormat) {
        ImageMdsMeta imageMdsMeta = BannerImageConverter.toImageMdsMeta(bannerImageFormat.getMdsMeta());
        if (imageMdsMeta != null && imageMdsMeta.getMeta() != null && imageMdsMeta.getMeta().getOrigSizeBytes() > size * 1024) {
            return new Defect<>(getDefectId(), new ImageSizeKbParam(size));
        }

        return null;
    }

}
