package ru.yandex.direct.core.entity.internalads.restriction;

import java.util.regex.Pattern;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectId;

public class RestrictionRegexp implements RestrictionString {
    private final boolean isStrict;
    private final String regexp;
    private final Pattern pattern;

    RestrictionRegexp(boolean isStrict, String regexp) {
        this.isStrict = isStrict;
        this.regexp = regexp;
        this.pattern = Pattern.compile(regexp);
    }

    @Override
    public boolean isStrict() {
        return isStrict;
    }

    public String regexp() {
        return regexp;
    }

    @Override
    public DefectId<Void> getDefectId() {
        return InternalAdRestrictionDefects.Gen.FORMAT_INVALID;
    }

    @Nullable
    @Override
    public Defect check(@Nullable String value) {
        if (value == null) {
            return null;
        }
        if (!pattern.matcher(value).matches()) {
            return createUrlDefect();
        }
        return null;
    }

    @Nonnull
    private Defect<Void> createUrlDefect() {
        return new Defect<>(getDefectId());
    }
}
