package ru.yandex.direct.core.entity.internalads.restriction;

import java.util.Map;

import javax.annotation.Nullable;

import one.util.streamex.StreamEx;
import org.apache.commons.lang.StringUtils;

import ru.yandex.direct.validation.result.Defect;

import static ru.yandex.direct.core.entity.internalads.Constants.ALLOWED_SPEC_SYMBOLS_FOR_TEXT;
import static ru.yandex.direct.core.entity.internalads.Constants.ALLOWED_TAGS_FOR_TEXT;

abstract class RestrictionTextLength implements RestrictionString {

    private static final Map<String, Integer> SPEC_SYMBOLS_TO_LENGTH = StreamEx.of(ALLOWED_SPEC_SYMBOLS_FOR_TEXT)
            .mapToEntry(s -> 1)
            .append(ALLOWED_TAGS_FOR_TEXT)
            .mapKeys(s -> ALLOWED_SPEC_SYMBOLS_FOR_TEXT.contains(s) ?
                    String.format("&%s;", s) : String.format("<%s>", s))
            .toMap();

    static int validationLength(String text) {
        int length = text.length();
        for (String specSymbol : SPEC_SYMBOLS_TO_LENGTH.keySet()) {
            int matches = StringUtils.countMatches(text, specSymbol);
            length += matches * (SPEC_SYMBOLS_TO_LENGTH.get(specSymbol) - specSymbol.length());
        }
        return length;
    }

    @Nullable
    abstract Defect checkRestriction(String value);

    @Nullable
    @Override
    public Defect check(@Nullable String value) {
        if (value == null) {
            return null;
        }

        if (value.startsWith(" ") || value.endsWith(" ")) {
            return new Defect<>(InternalAdRestrictionDefects.Text.TEXT_HAS_SPACES_AROUND);
        }

        return checkRestriction(value);
    }
}
