package ru.yandex.direct.core.entity.internalads.restriction;

import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.internalads.restriction.InternalAdRestrictionDefects.TextLengthParam;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectId;

import static com.google.common.base.Preconditions.checkArgument;

public class RestrictionTextLengthMin extends RestrictionTextLength {
    private final boolean isStrict;
    private final int length;

    RestrictionTextLengthMin(boolean isStrict, int length) {
        checkArgument(length > 0);
        this.isStrict = isStrict;
        this.length = length;
    }

    public int getLength() {
        return length;
    }

    @Override
    public boolean isStrict() {
        return isStrict;
    }

    @Override
    public DefectId<TextLengthParam> getDefectId() {
        return InternalAdRestrictionDefects.Length.TEXT_TOO_SHORT;
    }

    @Nullable
    @Override
    public Defect checkRestriction(String value) {
        if (validationLength(value) < length) {
            return new Defect<>(getDefectId(), new TextLengthParam(length, null));
        }

        return null;
    }
}
