package ru.yandex.direct.core.entity.internalads.restriction;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.internalads.restriction.InternalAdRestrictionDefects.UrlCorrectParam;
import ru.yandex.direct.validation.constraint.StringConstraints;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectId;

public class RestrictionUrlCorrect implements RestrictionString {
    private static final String HTTPS_PREFIX = "https://";
    private static final String HTTP_PREFIX = "http://";

    private final boolean isStrict;
    private final boolean isHttpsOnly;

    RestrictionUrlCorrect(boolean isStrict, boolean isHttpsOnly) {
        this.isStrict = isStrict;
        this.isHttpsOnly = isHttpsOnly;
    }

    @Override
    public boolean isStrict() {
        return isStrict;
    }

    public boolean isHttpsOnly() {
        return isHttpsOnly;
    }

    @Override
    public DefectId<UrlCorrectParam> getDefectId() {
        return InternalAdRestrictionDefects.Url.URL_NOT_VALID;
    }

    @Nullable
    @Override
    public Defect check(@Nullable String value) {
        if (value == null) {
            return null;
        }

        // TODO: вынести проверку в отдельный класс
        if (value.contains(" ")) {
            return createUrlWithSpacesDefect();
        }

        if (!StringConstraints.isValidHref(value)) {
            return createUrlDefect();
        }

        if (isHttpsOnly && !value.startsWith(HTTPS_PREFIX)) {
            return createUrlDefect();
        }

        if (!value.startsWith(HTTPS_PREFIX) && !value.startsWith(HTTP_PREFIX)) {
            return createUrlDefect();
        }
        return null;
    }

    @Nonnull
    private Defect<UrlCorrectParam> createUrlDefect() {
        return new Defect<>(getDefectId(), new UrlCorrectParam(isHttpsOnly));
    }

    @Nonnull
    private Defect<Void> createUrlWithSpacesDefect() {
        return new Defect<>(InternalAdRestrictionDefects.UrlWithSpaces.URL_HAS_SPACES);
    }
}
