package ru.yandex.direct.core.entity.internalads.restriction;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import static ru.yandex.direct.core.entity.internalads.restriction.RestrictionImageFormat.GIF;
import static ru.yandex.direct.core.entity.internalads.restriction.RestrictionImageFormat.JPEG;
import static ru.yandex.direct.core.entity.internalads.restriction.RestrictionImageFormat.PNG;
import static ru.yandex.direct.core.entity.internalads.restriction.RestrictionImageFormat.SVG;

@SuppressWarnings("WeakerAccess")
@ParametersAreNonnullByDefault
public class Restrictions {
    private static final int DEFAULT_URL_MAX_LENGTH = 2000;
    private static final int DEFAULT_TEXT_MAX_LENGTH = 2000;
    public static final int DEFAULT_IMAGE_MAX_SIZE_KB = 200;
    private static final int DEFAULT_IMAGE_MAX_WIDTH = 4000;
    private static final int DEFAULT_IMAGE_MAX_HEIGHT = 4000;

    private Restrictions() {
    }

    public static RestrictionImageDimensionsEq imageDimensionsEq(boolean strict, @Nullable Integer width,
                                                                 @Nullable Integer height) {
        return imageDimensionsEq(strict, width, height, null);
    }

    public static RestrictionImageDimensionsEq imageDimensionsEq(boolean strict, @Nullable Integer width,
                                                                 @Nullable Integer height,
                                                                 @Nullable Set<RestrictionImageFormat> formatsForCheck) {
        return new RestrictionImageDimensionsEq(strict, width, height, formatsForCheck);
    }

    public static RestrictionImageDimensionsSquare imageDimensionsSquare(boolean strict,
                                                                         @Nullable Set<RestrictionImageFormat> formatsForCheck) {
        return new RestrictionImageDimensionsSquare(strict, formatsForCheck);
    }

    public static RestrictionImageDimensionsMin imageDimensionsMin(boolean strict, @Nullable Integer width,
                                                                   @Nullable Integer height) {
        return new RestrictionImageDimensionsMin(strict, width, height, null);
    }

    public static RestrictionImageDimensionsMax imageDimensionsMax(boolean strict, @Nullable Integer width,
                                                                   @Nullable Integer height) {
        return new RestrictionImageDimensionsMax(strict, width, height, null);
    }

    public static RestrictionImageFormatIn imageFormatIn(boolean strict, Collection<RestrictionImageFormat> formats) {
        return new RestrictionImageFormatIn(strict, Set.copyOf(formats));
    }

    public static RestrictionImageSizeKbMax imageSizeKbMax(boolean strict, int size) {
        return new RestrictionImageSizeKbMax(strict, size, null);
    }

    public static RestrictionTextLengthMin minTextLength(boolean strict, int length) {
        return new RestrictionTextLengthMin(strict, length);
    }

    public static RestrictionTextLengthMax maxTextLength(boolean strict, int length) {
        return new RestrictionTextLengthMax(strict, length);
    }

    public static RestrictionUrlCorrect urlIsCorrect(boolean strict, boolean isHttpsOnly) {
        return new RestrictionUrlCorrect(strict, isHttpsOnly);
    }

    public static RestrictionRegexp regexp(boolean strict, String regexp) {
        return new RestrictionRegexp(strict, regexp);
    }

    public static List<Restriction> defaultAge() {
        return Collections.emptyList();
    }

    public static List<Restriction> defaultCloseCounter() {
        return Collections.emptyList();
    }

    public static List<Restriction> defaultText() {
        return List.of(
                new RestrictionTextLengthMax(true, DEFAULT_TEXT_MAX_LENGTH)
        );
    }

    public static List<Restriction> defaultUrl() {
        return List.of(
                Restrictions.maxTextLength(true, DEFAULT_URL_MAX_LENGTH),
                Restrictions.urlIsCorrect(true, false)
        );
    }

    public static List<Restriction> defaultImage() {
        return List.of(
                Restrictions.imageSizeKbMax(true, DEFAULT_IMAGE_MAX_SIZE_KB),
                Restrictions.imageDimensionsMax(true, DEFAULT_IMAGE_MAX_WIDTH, DEFAULT_IMAGE_MAX_HEIGHT),
                Restrictions.imageFormatIn(true, List.of(GIF, JPEG, PNG, SVG))
        );
    }

    public static List<Restriction> teaserHeader() {
        return List.of(
                Restrictions.maxTextLength(false, 20),
                Restrictions.maxTextLength(true, 22)
        );
    }

    public static List<Restriction> teaserLabel() {
        return List.of(
                Restrictions.maxTextLength(false, 22),
                Restrictions.maxTextLength(true, 24)
        );
    }

    public static List<Restriction> teaserImg() {
        return List.of(
                Restrictions.imageFormatIn(true, List.of(PNG)),
                Restrictions.imageSizeKbMax(true, 100),
                Restrictions.imageDimensionsEq(true, 120, 90)
        );
    }

    public static List<Restriction> teaserRetinaImg() {
        return List.of(
                Restrictions.imageFormatIn(true, List.of(PNG)),
                Restrictions.imageSizeKbMax(true, 100),
                Restrictions.imageDimensionsEq(true, 240, 180)
        );
    }

    public static List<Restriction> underSearchImg() {
        return List.of(
                Restrictions.imageFormatIn(true, List.of(PNG)),
                Restrictions.imageSizeKbMax(true, 30),
                Restrictions.imageDimensionsEq(true, null, 18),
                Restrictions.imageDimensionsMax(true, 35, null)
        );
    }

    public static List<Restriction> underSearchRetinaImg() {
        return List.of(
                Restrictions.imageFormatIn(true, List.of(PNG)),
                Restrictions.imageSizeKbMax(true, 30),
                Restrictions.imageDimensionsEq(true, null, 36),
                Restrictions.imageDimensionsMax(true, 70, null)
        );
    }

    public static List<Restriction> seprFooterImg() {
        return List.of(
                Restrictions.imageFormatIn(true, List.of(PNG, SVG)),
                Restrictions.imageSizeKbMax(true, 20),
                Restrictions.imageDimensionsEq(true, 100, 100)
        );
    }

    public static List<Restriction> afishaImg() {
        return List.of(
                Restrictions.imageFormatIn(true, List.of(PNG, JPEG, GIF)),
                Restrictions.imageSizeKbMax(true, 4915), // 4.8 Mб
                Restrictions.imageDimensionsEq(true, 300, 100)
        );
    }

    public static List<Restriction> regexp(String regexp) {
        return List.of(Restrictions.regexp(true, regexp));
    }

}
