package ru.yandex.direct.core.entity.internalads.service;

import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;

import com.google.common.collect.ImmutableMap;
import org.apache.commons.lang3.tuple.Pair;

class InternalAdUrlSpecificHandler {
    private final Pattern domainMatchingPattern;
    private final Map<String, Pair<String, String>> defaultParametersByName;

    InternalAdUrlSpecificHandler(Pattern domainMatchingPattern,
                                 Map<String, Pair<String, String>> defaultParametersByName) {
        this.domainMatchingPattern = domainMatchingPattern;

        this.defaultParametersByName = ImmutableMap.copyOf(defaultParametersByName);
    }

    boolean handlesDomain(String domain) {
        return domainMatchingPattern.matcher(domain).find();
    }

    Map<String, Pair<String, String>> getDefaultParametersByName() {
        return defaultParametersByName;
    }

    Collection<Pair<String, String>> getDefaultParameters() {
        return defaultParametersByName.values();
    }
}
