package ru.yandex.direct.core.entity.internalads.service;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

import org.apache.commons.lang3.tuple.Pair;

class InternalAdUrlSpecificHandlerBuilder {
    private final Pattern domainMatchingPattern;
    private final Map<String, Pair<String, String>> defaultParametersByName;

    InternalAdUrlSpecificHandlerBuilder(String domainMatchingPatterns) {
        domainMatchingPattern = Pattern.compile(domainMatchingPatterns);

        defaultParametersByName = new HashMap<>();
    }

    InternalAdUrlSpecificHandlerBuilder defaultParameter(String name, String value) {
        Pair<String, String> parameter = Pair.of(name, value);
        defaultParametersByName.put(name, parameter);
        return this;
    }

    InternalAdUrlSpecificHandler build() {
        return new InternalAdUrlSpecificHandler(domainMatchingPattern,
                defaultParametersByName);
    }
}
