package ru.yandex.direct.core.entity.internalads.service;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableMap;

import ru.yandex.direct.core.entity.internalads.model.InternalAdsProductAccessType;
import ru.yandex.direct.rbac.model.ClientsRelationType;

@ParametersAreNonnullByDefault
public class InternalAdsConverter {

    private static final ImmutableMap<InternalAdsProductAccessType, ClientsRelationType>
            INTERNAL_ADS_PRODUCT_ACCESS_TYPE_CONVERTER_MAP = ImmutableMap.<InternalAdsProductAccessType,
            ClientsRelationType>builder()
            .put(InternalAdsProductAccessType.INTERNAL_AD_PUBLISHER, ClientsRelationType.INTERNAL_AD_PUBLISHER)
            .put(InternalAdsProductAccessType.INTERNAL_AD_READER, ClientsRelationType.INTERNAL_AD_READER)
            .build();

    static ClientsRelationType convertToInternalClientRelationType(
            InternalAdsProductAccessType internalAdsProductAccessType) {
        INTERNAL_ADS_PRODUCT_ACCESS_TYPE_CONVERTER_MAP.getOrDefault(internalAdsProductAccessType,
                null);
        return ClientsRelationType.valueOf(internalAdsProductAccessType.name());
    }
}
