package ru.yandex.direct.core.entity.internalads.service.validation.defects;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.validation.result.Defect;

import static ru.yandex.direct.core.entity.internalads.service.validation.defects.InternalAdDefectIds.INVALID_PLACE_ID;
import static ru.yandex.direct.core.entity.internalads.service.validation.defects.InternalAdDefectIds.PRODUCT_ACCESS_DOES_NOT_EXIST;
import static ru.yandex.direct.core.entity.internalads.service.validation.defects.InternalAdDefectIds.PRODUCT_ACCESS_EXISTS;
import static ru.yandex.direct.core.entity.internalads.service.validation.defects.InternalAdDefectIds.PRODUCT_WITH_THIS_NAME_ALREADY_EXISTS;
import static ru.yandex.direct.core.entity.internalads.service.validation.defects.InternalAdDefectIds.REQUIRED_IMPRESSION_RATE_DUE_TO_RF_CLOSE_BY_CLICK;
import static ru.yandex.direct.core.entity.internalads.service.validation.defects.InternalAdDefectIds.TEMPLATE_NOT_FOUND;
import static ru.yandex.direct.core.entity.internalads.service.validation.defects.InternalAdDefectIds.UNKNOWN_CLIENT_ID;
import static ru.yandex.direct.core.entity.internalads.service.validation.defects.InternalAdStringDefectIds.RESOURCE_RESTRICTIONS_NOT_FOLLOWED;
import static ru.yandex.direct.core.entity.internalads.service.validation.defects.InternalAdStringDefectIds.URL_UNREACHABLE;

@ParametersAreNonnullByDefault
public class InternalAdDefects {
    private InternalAdDefects() {
    }

    public static Defect<Void> unknownClientId() {
        return new Defect<>(UNKNOWN_CLIENT_ID);
    }

    public static Defect<Void> accessAlreadyExists() {
        return new Defect<>(PRODUCT_ACCESS_EXISTS);
    }

    public static Defect<Void> accessDoesNotExist() {
        return new Defect<>(PRODUCT_ACCESS_DOES_NOT_EXIST);
    }

    public static Defect<Void> productWithThisNameAlreadyExists() {
        return new Defect<>(PRODUCT_WITH_THIS_NAME_ALREADY_EXISTS);
    }

    public static Defect<Void> invalidPlaceId() {
        return new Defect<>(INVALID_PLACE_ID);
    }

    public static Defect<Void> templateNotFound() {
        return new Defect<>(TEMPLATE_NOT_FOUND);
    }

    public static Defect<String> urlUnreachable(String message) {
        return new Defect<>(URL_UNREACHABLE, message);
    }

    public static Defect<String> resourceRestrictionsNotFollowed(String message) {
        return new Defect<>(RESOURCE_RESTRICTIONS_NOT_FOLLOWED, message);
    }

    public static Defect<Void> requiredImpressionRateDueToRfCloseByClick() {
        return new Defect<>(REQUIRED_IMPRESSION_RATE_DUE_TO_RF_CLOSE_BY_CLICK);
    }

}
