package ru.yandex.direct.core.entity.inventori.service.type;

import java.util.List;
import java.util.Map;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.model.PageBlock;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierDemographics;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierDesktop;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierMobile;
import ru.yandex.direct.core.entity.campaign.model.CampaignForForecast;
import ru.yandex.direct.core.entity.creative.model.Creative;
import ru.yandex.direct.core.entity.pricepackage.model.PricePackage;
import ru.yandex.direct.core.entity.retargeting.model.Goal;
import ru.yandex.direct.core.entity.retargeting.model.RetargetingCondition;
import ru.yandex.direct.inventori.model.request.CampaignParametersCorrections;
import ru.yandex.direct.inventori.model.request.MainPageTrafficType;
import ru.yandex.direct.inventori.model.request.ProjectParameter;

import static com.google.common.base.Preconditions.checkNotNull;

@ParametersAreNonnullByDefault
public class AdGroupData {

    private FrontendData frontendData;

    private final AdGroup adGroup;

    private final CampaignForForecast campaign;

    private final List<RetargetingCondition> retargetingConditions;

    private final List<Long> bannerIds;

    private final Map<Long, Goal> goalIdToCryptaGoalMapping;

    private final Map<Long, Creative> creativesByBannerId;

    private final List<PageBlock> pageBlocks;

    private final List<PageBlock> excludedPageBlocks;

    private final CampaignParametersCorrections corrections;

    private final BidModifierDesktop bidModifierDesktop;

    private final BidModifierMobile bidModifierMobile;

    private final BidModifierDemographics bidModifierDemographics;

    private final MainPageTrafficType mainPageTrafficType;

    private final List<String> targetTags;

    private final List<String> orderTags;

    private final Boolean enableNonSkippableVideo;

    private final Boolean isDefaultAdGroup;

    private final PricePackage pricePackage;

    private final List<ProjectParameter> projectParameters;

    private AdGroupData(FrontendData frontendData, AdGroup adGroup,
                        CampaignForForecast campaign,
                        List<RetargetingCondition> retargetingConditions,
                        List<Long> bannerIds,
                        Map<Long, Goal> goalIdToCryptaGoalMapping,
                        Map<Long, Creative> creativesByBannerId,
                        List<PageBlock> pageBlocks,
                        List<PageBlock> excludedPageBlocks,
                        @Nullable CampaignParametersCorrections corrections,
                        @Nullable BidModifierDesktop bidModifierDesktop,
                        @Nullable BidModifierMobile bidModifierMobile,
                        @Nullable BidModifierDemographics bidModifierDemographics,
                        @Nullable MainPageTrafficType mainPageTrafficType,
                        @Nullable List<String> targetTags,
                        @Nullable List<String> orderTags,
                        @Nullable Boolean enableNonSkippableVideo,
                        @Nullable Boolean isDefaultAdGroup,
                        @Nullable PricePackage pricePackage,
                        @Nullable List<ProjectParameter> projectParameters) {
        this.frontendData = frontendData;
        this.adGroup = checkNotNull(adGroup);
        this.campaign = checkNotNull(campaign);
        this.retargetingConditions = checkNotNull(retargetingConditions);
        this.bannerIds = checkNotNull(bannerIds);
        this.goalIdToCryptaGoalMapping = checkNotNull(goalIdToCryptaGoalMapping);
        this.creativesByBannerId = checkNotNull(creativesByBannerId);
        this.pageBlocks = checkNotNull(pageBlocks);
        this.excludedPageBlocks = checkNotNull(excludedPageBlocks);
        this.corrections = corrections;
        this.bidModifierDesktop = bidModifierDesktop;
        this.bidModifierMobile = bidModifierMobile;
        this.bidModifierDemographics = bidModifierDemographics;
        this.mainPageTrafficType = mainPageTrafficType;
        this.targetTags = targetTags;
        this.orderTags = orderTags;
        this.enableNonSkippableVideo = enableNonSkippableVideo;
        this.isDefaultAdGroup = isDefaultAdGroup;
        this.pricePackage = pricePackage;
        this.projectParameters = projectParameters;
    }

    public AdGroup getAdGroup() {
        return adGroup;
    }

    public CampaignForForecast getCampaign() {
        return campaign;
    }

    public List<RetargetingCondition> getRetargetingConditions() {
        return retargetingConditions;
    }

    public List<Long> getBannerIds() {
        return bannerIds;
    }

    public Map<Long, Goal> getGoalIdToCryptaGoalMapping() {
        return goalIdToCryptaGoalMapping;
    }

    public Map<Long, Creative> getCreativesByBannerId() {
        return creativesByBannerId;
    }

    public List<PageBlock> getPageBlocks() {
        return pageBlocks;
    }

    public List<PageBlock> getExcludedPageBlocks() {
        return excludedPageBlocks;
    }

    @Nullable
    public BidModifierDesktop getBidModifierDesktop() {
        return bidModifierDesktop;
    }

    @Nullable
    public BidModifierMobile getBidModifierMobile() {
        return bidModifierMobile;
    }

    @Nullable
    public BidModifierDemographics getBidModifierDemographics() {
        return bidModifierDemographics;
    }

    @Nullable
    public MainPageTrafficType getMainPageTrafficType() {
        return mainPageTrafficType;
    }

    @Nullable
    public List<String> getTargetTags() {
        return targetTags;
    }

    @Nullable
    public List<String> getOrderTags() {
        return orderTags;
    }

    public FrontendData getFrontendData() {
        return frontendData;
    }

    @Nullable
    public CampaignParametersCorrections getCorrections() {
        return corrections;
    }

    @Nullable
    public Boolean getEnableNonSkippableVideo() {
        return enableNonSkippableVideo;
    }

    @Nullable
    public Boolean getIsDefaultAdGroup() {
        return isDefaultAdGroup;
    }

    @Nullable
    public PricePackage getPricePackage() {
        return pricePackage;
    }

    @Nullable
    public List<ProjectParameter> getProjectParameters() {
        return projectParameters;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {

        private FrontendData frontendData;
        private AdGroup adGroup;
        private CampaignForForecast campaign;
        private List<RetargetingCondition> retargetingConditions;
        private List<Long> bannerIds;
        private Map<Long, Goal> goalIdToCryptaGoalMapping;
        private CampaignParametersCorrections corrections;
        private BidModifierDesktop bidModifierDesktop;
        private BidModifierMobile bidModifierMobile;
        private BidModifierDemographics bidModifierDemographics;
        private MainPageTrafficType mainPageTrafficType;
        private Map<Long, Creative> creativesByBannerId;
        private List<PageBlock> pageBlocks;
        private List<PageBlock> excludedPageBlocks;
        private List<String> targetTags;
        private List<String> orderTags;
        private Boolean enableNonSkippableVideo;
        private Boolean isDefaultAdGroup;
        private PricePackage pricePackage;
        private List<ProjectParameter> projectParameters;

        public Builder withFrontendData(@Nullable FrontendData frontendData) {
            this.frontendData = frontendData;
            return this;
        }

        public Builder withAdGroup(AdGroup adGroup) {
            this.adGroup = adGroup;
            return this;
        }

        public Builder withCampaign(CampaignForForecast campaign) {
            this.campaign = campaign;
            return this;
        }

        public Builder withRetargetingConditions(
                List<RetargetingCondition> retargetingConditions) {
            this.retargetingConditions = retargetingConditions;
            return this;
        }

        public Builder withBannerIds(List<Long> bannerIds) {
            this.bannerIds = bannerIds;
            return this;
        }

        public Builder withGoalIdToCryptaGoalMapping(
                Map<Long, Goal> goalIdToCryptaGoalMapping) {
            this.goalIdToCryptaGoalMapping = goalIdToCryptaGoalMapping;
            return this;
        }

        public Builder withBidModifierDesktop(@Nullable BidModifierDesktop bidModifierDesktop) {
            this.bidModifierDesktop = bidModifierDesktop;
            return this;
        }

        public Builder withBidModifierMobile(@Nullable BidModifierMobile bidModifierMobile) {
            this.bidModifierMobile = bidModifierMobile;
            return this;
        }

        public Builder withBidModifierDemographics(@Nullable BidModifierDemographics bidModifierDemographics) {
            this.bidModifierDemographics = bidModifierDemographics;
            return this;
        }

        public Builder withMainPageTrafficType(@Nullable MainPageTrafficType mainPageTrafficType) {
            this.mainPageTrafficType = mainPageTrafficType;
            return this;
        }

        public Builder withCreativesByBannerId(
                Map<Long, Creative> creativesByBannerId) {
            this.creativesByBannerId = creativesByBannerId;
            return this;
        }

        public Builder withPageBlocks(List<PageBlock> pageBlocks) {
            this.pageBlocks = pageBlocks;
            return this;
        }

        public Builder withExcludedPageBlocks(List<PageBlock> excludedPageBlocks) {
            this.excludedPageBlocks = excludedPageBlocks;
            return this;
        }

        public Builder withCorrections(@Nullable CampaignParametersCorrections corrections) {
            this.corrections = corrections;
            return this;
        }

        public Builder withTargetTags(@Nullable List<String> targetTags) {
            this.targetTags = targetTags;
            return this;
        }

        public Builder withOrderTags(@Nullable List<String> orderTags) {
            this.orderTags = orderTags;
            return this;
        }

        public Builder withEnableNonSkippableVideo(Boolean enableNonSkippableVideo) {
            this.enableNonSkippableVideo = enableNonSkippableVideo;
            return this;
        }

        public Builder withIsDefaultAdGroup(@Nullable Boolean isDefaultAdGroup) {
            this.isDefaultAdGroup = isDefaultAdGroup;
            return this;
        }

        public Builder withPricePackage(@Nullable PricePackage pricePackage) {
            this.pricePackage = pricePackage;
            return this;
        }

        public Builder withProjectParameters(List<ProjectParameter> projectParameters) {
            this.projectParameters = projectParameters;
            return this;
        }

        public AdGroupData build() {
            return new AdGroupData(frontendData, adGroup, campaign, retargetingConditions, bannerIds,
                    goalIdToCryptaGoalMapping, creativesByBannerId, pageBlocks, excludedPageBlocks, corrections,
                    bidModifierDesktop, bidModifierMobile, bidModifierDemographics, mainPageTrafficType, targetTags,
                    orderTags, enableNonSkippableVideo, isDefaultAdGroup, pricePackage, projectParameters);
        }
    }
}
