package ru.yandex.direct.core.entity.inventori.service.type;

import java.util.List;
import java.util.Set;

import ru.yandex.direct.core.entity.creative.model.Creative;
import ru.yandex.direct.core.entity.retargeting.model.RetargetingCondition;
import ru.yandex.direct.inventori.model.request.AudioCreative;
import ru.yandex.direct.inventori.model.request.BlockSize;
import ru.yandex.direct.inventori.model.request.GroupType;
import ru.yandex.direct.inventori.model.request.PageBlock;
import ru.yandex.direct.inventori.model.request.PlatformCorrections;
import ru.yandex.direct.inventori.model.request.ProfileCorrection;
import ru.yandex.direct.inventori.model.request.VideoCreative;

public class FrontendData {

    private Long groupId;

    private GroupType groupType;

    private Set<Integer> geo;

    private List<BlockSize> blockSizes;

    private Boolean hasAdaptiveCreative;

    // От видео групп креативы поступают в виде списка длительностей (поле duration)
    private List<VideoCreative> videoCreatives;

    // От индора и аутдора креативы поступают в виде списка ид
    private List<Long> videoCreativeIds;
    // Заполняем это поле из базы по videoCreativeIds
    private List<Creative> creatives;

    private List<AudioCreative> audioCreatives;

    private List<PageBlock> pageBlocks;

    private List<RetargetingCondition> conditions;

    private List<ProfileCorrection> profileCorrections;

    private PlatformCorrections platformCorrections;

    private List<String> targetTags;

    private List<String> excludedBsCategories;

    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public FrontendData withGroupId(Long groupId) {
        this.groupId = groupId;
        return this;
    }

    public GroupType getGroupType() {
        return groupType;
    }

    public void setGroupType(GroupType groupType) {
        this.groupType = groupType;
    }

    public Set<Integer> getGeo() {
        return geo;
    }

    public void setGeo(Set<Integer> geo) {
        this.geo = geo;
    }

    public List<BlockSize> getBlockSizes() {
        return blockSizes;
    }

    public void setBlockSizes(List<BlockSize> blockSizes) {
        this.blockSizes = blockSizes;
    }

    public List<VideoCreative> getVideoCreatives() {
        return videoCreatives;
    }

    public void setVideoCreatives(List<VideoCreative> videoCreatives) {
        this.videoCreatives = videoCreatives;
    }

    public List<AudioCreative> getAudioCreatives() {
        return audioCreatives;
    }

    public void setAudioCreatives(List<AudioCreative> audioCreatives) {
        this.audioCreatives = audioCreatives;
    }

    public Boolean getHasAdaptiveCreative() {
        return hasAdaptiveCreative;
    }

    public void setHasAdaptiveCreative(Boolean hasAdaptiveCreative) {
        this.hasAdaptiveCreative = hasAdaptiveCreative;
    }

    public List<String> getExcludedBsCategories() { return excludedBsCategories; }

    public void setExcludedBsCategories(List<String> excludedBsCategories) { this.excludedBsCategories = excludedBsCategories; }

    public List<RetargetingCondition> getConditions() {
        return conditions;
    }

    public void setConditions(List<RetargetingCondition> conditions) {
        this.conditions = conditions;
    }

    public PlatformCorrections getPlatformCorrections() {
        return platformCorrections;
    }

    public void setPlatformCorrections(PlatformCorrections platformCorrections) {
        this.platformCorrections = platformCorrections;
    }

    public FrontendData withGeo(Set<Integer> geo) {
        this.geo = geo;
        return this;
    }

    public FrontendData withExcludedBsCategories(List<String> excludedBsCategories) {
        this.excludedBsCategories = excludedBsCategories;
        return this;
    }

    public FrontendData withBlockSizes(List<BlockSize> blockSizes) {
        this.blockSizes = blockSizes;
        return this;
    }

    public FrontendData withVideoCreatives(List<VideoCreative> videoCreatives) {
        this.videoCreatives = videoCreatives;
        return this;
    }

    public FrontendData withAudioCreatives(List<AudioCreative> audioCreatives) {
        this.audioCreatives = audioCreatives;
        return this;
    }

    public FrontendData withConditions(List<RetargetingCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public FrontendData withPlatformCorrections(PlatformCorrections platformCorrections) {
        this.platformCorrections = platformCorrections;
        return this;
    }

    public FrontendData withGroupType(GroupType groupType) {
        this.groupType = groupType;
        return this;
    }

    public FrontendData withHasAdaptiveCreative(Boolean hasAdaptiveCreative) {
        this.hasAdaptiveCreative = hasAdaptiveCreative;
        return this;
    }

    public List<PageBlock> getPageBlocks() {
        return pageBlocks;
    }

    public FrontendData setPageBlocks(List<PageBlock> pageBlocks) {
        this.pageBlocks = pageBlocks;
        return this;
    }

    public List<ProfileCorrection> getProfileCorrections() {
        return profileCorrections;
    }

    public FrontendData setProfileCorrections(List<ProfileCorrection> profileCorrections) {
        this.profileCorrections = profileCorrections;
        return this;
    }

    public FrontendData withPageBlocks(List<PageBlock> pageBlocks) {
        this.pageBlocks = pageBlocks;
        return this;
    }

    public FrontendData withProfileCorrections(List<ProfileCorrection> profileCorrections) {
        this.profileCorrections = profileCorrections;
        return this;
    }

    public FrontendData withVideoCreativeIds(List<Long> videoCreativeIds) {
        this.videoCreativeIds = videoCreativeIds;
        return this;
    }

    public List<Long> getVideoCreativeIds() {
        return videoCreativeIds;
    }

    public void setVideoCreativeIds(List<Long> videoCreativeIds) {
        this.videoCreativeIds = videoCreativeIds;
    }

    public FrontendData withCreatives(List<Creative> creatives) {
        this.creatives = creatives;
        return this;
    }

    public List<Creative> getCreatives() {
        return creatives;
    }

    public FrontendData withTargetTags(List<String> targetTags) {
        this.targetTags = targetTags;
        return this;
    }

    public List<String> getTargetTags() {
        return targetTags;
    }
}
