package ru.yandex.direct.core.entity.keyword.container;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;

import static com.google.common.base.Preconditions.checkArgument;

public class AdGroupInfoForKeywordAdd {
    private Integer adGroupIndex;
    private Long campaignId;
    private AdGroupType adGroupType;

    public AdGroupInfoForKeywordAdd(Integer adGroupIndex, Long campaignId,
                                    AdGroupType adGroupType) {
        checkArgument(adGroupIndex != null, "adGroupIndex should not be null");
        checkArgument(campaignId != null, "campaignId should not be null");
        checkArgument(adGroupType != null, "adGroupType should not be null");
        this.adGroupIndex = adGroupIndex;
        this.campaignId = campaignId;
        this.adGroupType = adGroupType;
    }

    public Integer getAdGroupIndex() {
        return adGroupIndex;
    }

    public Long getCampaignId() {
        return campaignId;
    }

    public AdGroupType getAdGroupType() {
        return adGroupType;
    }
}
