package ru.yandex.direct.core.entity.keyword.container;

import java.util.List;

public class AddedKeywordInfo {

    private Long id;
    private Long adGroupId;
    private boolean added;

    /**
     * Фраза, получившаяся в результате после всех обработок (не в нормальной форме).
     */
    private String resultPhrase;

    /**
     * Фраза перед добавлением к ней минус-слов в процессе расклейки.
     * Присутствует только для добавленных фраз (added = true).
     */
    private String phraseBeforeUnglue;

    /**
     * Описание фиксаций стоп-слов.
     * Может быть равно null, если стоп-слова не были зафиксированы.
     */
    private List<StopwordsFixation> fixations;

    /**
     * Добавленные в результате расклейки минус-слова.
     * Может быть равно null, если минус-слова не были добавлены.
     */
    private List<String> addedMinuses;

    public Long getId() {
        return id;
    }

    public AddedKeywordInfo withId(Long id) {
        this.id = id;
        return this;
    }

    public Long getAdGroupId() {
        return adGroupId;
    }

    public AddedKeywordInfo withAdGroupId(Long adGroupId) {
        this.adGroupId = adGroupId;
        return this;
    }


    public boolean isAdded() {
        return added;
    }

    public AddedKeywordInfo withAdded(boolean added) {
        this.added = added;
        return this;
    }

    public String getResultPhrase() {
        return resultPhrase;
    }

    public AddedKeywordInfo withResultPhrase(String resultPhrase) {
        this.resultPhrase = resultPhrase;
        return this;
    }

    public String getPhraseBeforeUnglue() {
        return phraseBeforeUnglue;
    }

    public AddedKeywordInfo withPhraseBeforeUnglue(String phraseBeforeUnglue) {
        this.phraseBeforeUnglue = phraseBeforeUnglue;
        return this;
    }

    public List<StopwordsFixation> getFixations() {
        return fixations;
    }

    public AddedKeywordInfo withFixations(
            List<StopwordsFixation> fixations) {
        this.fixations = fixations;
        return this;
    }

    public List<String> getAddedMinuses() {
        return addedMinuses;
    }

    public AddedKeywordInfo withAddedMinuses(List<String> addedMinuses) {
        this.addedMinuses = addedMinuses;
        return this;
    }
}
