package ru.yandex.direct.core.entity.keyword.container;

import java.util.List;

import com.google.common.collect.ImmutableList;

public class AffectedKeywordInfo {

    private final Long id;
    private final Long adGroupId;
    private final String sourcePhrase;
    private final ImmutableList<String> addedMinuses;
    private final Boolean isSuspended;

    public AffectedKeywordInfo(Long id, Long adGroupId, String sourcePhrase, List<String> addedMinuses,
                               Boolean isSuspended) {
        this.id = id;
        this.adGroupId = adGroupId;
        this.sourcePhrase = sourcePhrase;
        this.addedMinuses = ImmutableList.copyOf(addedMinuses);
        this.isSuspended = isSuspended;
    }

    public Long getId() {
        return id;
    }

    public Long getAdGroupId() {
        return adGroupId;
    }

    public String getSourcePhrase() {
        return sourcePhrase;
    }

    public List<String> getAddedMinuses() {
        return addedMinuses;
    }

    public Boolean getIsSuspended() {
        return isSuspended;
    }
}
