package ru.yandex.direct.core.entity.keyword.container;

import java.util.Objects;

public class CampaignIdAndKeywordIdPair {
    private final Long campaignId;
    private final Long keywordId;

    public CampaignIdAndKeywordIdPair(long campaignId, long keywordId) {
        this.campaignId = campaignId;
        this.keywordId = keywordId;
    }

    public Long getCampaignId() {
        return campaignId;
    }

    public Long getKeywordId() {
        return keywordId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CampaignIdAndKeywordIdPair that = (CampaignIdAndKeywordIdPair) o;
        return Objects.equals(campaignId, that.campaignId) &&
                Objects.equals(keywordId, that.keywordId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(campaignId, keywordId);
    }
}
