package ru.yandex.direct.core.entity.keyword.container;

import java.util.Collections;
import java.util.List;

import ru.yandex.direct.libs.keywordutils.model.KeywordWithMinuses;

/**
 * Результат работы фиксатора стоп-слов
 */
public class FixStopwordsResult {

    /**
     * Исходная фраза
     */
    private final KeywordWithMinuses sourceKeyword;

    /**
     * Итоговая фраза (если ничего не было зафиксировано - null)
     */
    private final KeywordWithMinuses destKeyword;

    /**
     * Зафиксированные подфразы
     */
    private final List<StopwordsFixation> fixations;

    public FixStopwordsResult(KeywordWithMinuses sourceKeyword,
                              KeywordWithMinuses destKeyword,
                              List<StopwordsFixation> fixations) {
        this.sourceKeyword = sourceKeyword;
        this.destKeyword = destKeyword;
        this.fixations = Collections.unmodifiableList(fixations);
    }

    /**
     * Если ничего не было зафиксировано - возвращает исходную фразу, иначе - новую
     */
    public KeywordWithMinuses getResult() {
        return isFixed() ? destKeyword : sourceKeyword;
    }

    public boolean isFixed() {
        return !fixations.isEmpty();
    }

    public KeywordWithMinuses getSourceKeyword() {
        return sourceKeyword;
    }

    public KeywordWithMinuses getDestKeyword() {
        return destKeyword;
    }

    public List<StopwordsFixation> getFixations() {
        return fixations;
    }
}
