package ru.yandex.direct.core.entity.keyword.container;

import ru.yandex.direct.core.entity.keyword.model.Keyword;
import ru.yandex.direct.libs.keywordutils.model.KeywordWithMinuses;

public class InternalKeyword {

    private Keyword keyword;
    private KeywordWithMinuses parsedKeyword;
    private KeywordWithMinuses parsedNormalKeyword;

    public InternalKeyword() {
    }

    public InternalKeyword(Keyword keyword, KeywordWithMinuses parsedKeyword) {
        this(keyword, parsedKeyword, null);
    }

    public InternalKeyword(Keyword keyword, KeywordWithMinuses parsedKeyword,
                           KeywordWithMinuses parsedNormalKeyword) {
        this.keyword = keyword;
        this.parsedKeyword = parsedKeyword;
        this.parsedNormalKeyword = parsedNormalKeyword;
    }

    public Long getId() {
        return getKeyword().getId();
    }

    public Long getAdGroupId() {
        return getKeyword().getAdGroupId();
    }

    public Long getCampaignId() {
        return getKeyword().getCampaignId();
    }

    public String getPhrase() {
        return getKeyword().getPhrase();
    }

    public Keyword getKeyword() {
        return keyword;
    }

    public InternalKeyword withKeyword(Keyword keyword) {
        this.keyword = keyword;
        return this;
    }

    public KeywordWithMinuses getParsedKeyword() {
        return parsedKeyword;
    }

    public InternalKeyword withParsedKeyword(KeywordWithMinuses parsedKeyword) {
        this.parsedKeyword = parsedKeyword;
        return this;
    }

    public KeywordWithMinuses getParsedNormalKeyword() {
        return parsedNormalKeyword;
    }

    public InternalKeyword withParsedNormalKeyword(KeywordWithMinuses parsedNormalKeyword) {
        this.parsedNormalKeyword = parsedNormalKeyword;
        return this;
    }
}
