package ru.yandex.direct.core.entity.keyword.container;

import ru.yandex.direct.core.entity.keyword.service.KeywordsAddOperation;

import static com.google.common.base.Preconditions.checkNotNull;

public class KeywordsAddOperationParams {

    /**
     * Расклейка: вкл/выкл.
     */
    private final boolean unglueEnabled;

    /**
     * Обозначает, что группы не существуют на момент prepare.
     * Используется в рамках комплексной операции добавления групп.
     */
    private final boolean adGroupsNonexistentOnPrepare;

    private final boolean ignoreOversize;
    private final boolean autoPrices;

    /**
     * Ослабленная валидация, пропускает проверки, которые могут не проходить для существующих фраз, используется при
     * копировании фраз
     */
    private final boolean weakenValidation;

    public static Builder builder() {
        return new Builder();
    }

    private KeywordsAddOperationParams(
            boolean adGroupsNonexistentOnPrepare, boolean unglueEnabled, boolean ignoreOversize, boolean autoPrices,
            boolean weakenValidation) {
        this.unglueEnabled = unglueEnabled;
        this.adGroupsNonexistentOnPrepare = adGroupsNonexistentOnPrepare;
        this.ignoreOversize = ignoreOversize;
        this.autoPrices = autoPrices;
        this.weakenValidation = weakenValidation;
    }

    public boolean isUnglueEnabled() {
        return unglueEnabled;
    }

    public boolean isAdGroupsNonexistentOnPrepare() {
        return adGroupsNonexistentOnPrepare;
    }

    public boolean isIgnoreOversize() {
        return ignoreOversize;
    }

    /**
     * Могут ли КФ во входных параметрах не иметь цен, обязательных для стратегии.
     * При этом нужно автоматически расчитывать недостающие ставки, см.
     * описание режима {@code autoPrices} в комменте к классу {@link KeywordsAddOperation}
     */
    public boolean isAutoPrices() {
        return autoPrices;
    }

    /**
     * Ослабленная валидация, пропускает проверки, которые могут не проходить для существующих фраз, используется при
     * копировании фраз
     */
    public boolean isWeakenValidation() {
        return weakenValidation;
    }

    public static final class Builder {

        private Boolean adGroupsNonexistentOnPrepare;
        private Boolean unglueEnabled;
        private Boolean ignoreOversize;
        private Boolean autoPrices;
        private Boolean weakenValidation;

        Builder() {
        }

        public Builder withAdGroupsNonexistentOnPrepare(boolean adGroupsNonexistentOnPrepare) {
            this.adGroupsNonexistentOnPrepare = adGroupsNonexistentOnPrepare;
            return this;
        }

        public Builder withUnglueEnabled(boolean unglueEnabled) {
            this.unglueEnabled = unglueEnabled;
            return this;
        }

        public Builder withIgnoreOversize(boolean ignoreOversize) {
            this.ignoreOversize = ignoreOversize;
            return this;
        }

        /**
         * Включает в операции режим автоматического выставления ставок,
         * которых нет в запросе, но они нужны в текущей стратегии, см.
         * коммент к классу {@link KeywordsAddOperation}.
         * При включении этого режима, параметр {@code fixedAutoPrices}
         * конструктора должен быть не {@code null}.
         */
        public Builder withAutoPrices(boolean autoPrices) {
            this.autoPrices = autoPrices;
            return this;
        }

        public Builder withWeakenValidation(boolean weakenValidation) {
            this.weakenValidation = weakenValidation;
            return this;
        }

        public KeywordsAddOperationParams build() {
            checkNotNull(adGroupsNonexistentOnPrepare, "adGroupsNonexistentOnPrepare must be specified");
            checkNotNull(unglueEnabled, "unglueEnabled must be specified");
            checkNotNull(ignoreOversize, "ignoreOversize must be specified");
            checkNotNull(autoPrices, "autoPrices must be specified");
            checkNotNull(weakenValidation, "weakenValidation must be specified");

            return new KeywordsAddOperationParams(
                    adGroupsNonexistentOnPrepare, unglueEnabled, ignoreOversize, autoPrices, weakenValidation);
        }
    }
}
