package ru.yandex.direct.core.entity.keyword.container;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.annotation.Nullable;

import com.google.common.collect.ImmutableList;
import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.keyword.model.Keyword;
import ru.yandex.direct.model.ModelChanges;

public class KeywordsModificationContainer {

    public static final String ADD_LIST_NAME = "addList";
    public static final String UPDATE_LIST_NAME = "updateList";
    public static final String DELETE_LIST_NAME = "deleteList";
    public static final String COPY_AD_GROUPS_LIST_NAME = "copyAdGroupsList";

    private final ImmutableList<Keyword> addList;
    private final ImmutableList<ModelChanges<Keyword>> updateList;
    private final ImmutableList<Long> deleteList;

    private final boolean copyOnOversize;

    private KeywordsModificationContainer(@Nullable List<Keyword> addList,
                                          @Nullable List<ModelChanges<Keyword>> updateList,
                                          @Nullable List<Long> deleteList,
                                          boolean copyOnOversize) {
        this.addList = addList != null ? ImmutableList.copyOf(addList) : null;
        this.updateList = updateList != null ? ImmutableList.copyOf(updateList) : null;
        this.deleteList = deleteList != null ? ImmutableList.copyOf(deleteList) : null;
        this.copyOnOversize = copyOnOversize;
    }

    public static KeywordsModificationContainer addUpdateDelete(List<Keyword> addList,
                                                                List<ModelChanges<Keyword>> updateList, List<Long> deleteList) {
        return new KeywordsModificationContainer(addList, updateList, deleteList, false);
    }

    public static KeywordsModificationContainer addWithCopyOnOversize(List<Keyword> addList) {
        return new KeywordsModificationContainer(addList, null, null, true);
    }

    @Nullable
    public List<Keyword> getAddList() {
        return addList;
    }

    @Nullable
    public List<ModelChanges<Keyword>> getUpdateList() {
        return updateList;
    }

    @Nullable
    public List<Long> getDeleteList() {
        return deleteList;
    }

    public boolean isCopyOnOversize() {
        return copyOnOversize;
    }

    public int getRequestSize() {
        return (addList != null ? addList.size() : 0) +
                (updateList != null ? updateList.size() : 0) +
                (deleteList != null ? deleteList.size() : 0);
    }

    public boolean isEmpty() {
        return getRequestSize() == 0;
    }

    public Set<Long> getKeywordIds() {
        Set<Long> keywordIds = new HashSet<>(getRequestSize());
        if (updateList != null) {
            Collection<Long> updatedIds = StreamEx.of(updateList)
                    .nonNull()
                    .map(ModelChanges::getId)
                    .nonNull()
                    .toList();
            keywordIds.addAll(updatedIds);
        }
        if (deleteList != null) {
            Collection<Long> deletedIds = StreamEx.of(deleteList)
                    .nonNull()
                    .toList();
            keywordIds.addAll(deletedIds);
        }
        return keywordIds;
    }
}
