package ru.yandex.direct.core.entity.keyword.container;

import java.util.List;
import java.util.Map;

import javax.annotation.Nullable;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;

public class KeywordsModificationResult {

    private final List<AddedKeywordInfo> addResults;
    private final List<UpdatedKeywordInfo> updateResults;
    private final List<Long> deleteResults;

    private Map<Long, Long> sourceAdGroupIdByCopiedAdGroupId;

    public KeywordsModificationResult(
            List<AddedKeywordInfo> addResults,
            List<UpdatedKeywordInfo> updateResults,
            List<Long> deleteResults,
            Map<Long, Long> sourceAdGroupIdByCopiedAdGroupId) {
        this.addResults = addResults != null ? ImmutableList.copyOf(addResults) : null;
        this.updateResults = updateResults != null ? ImmutableList.copyOf(updateResults) : null;
        this.deleteResults = deleteResults != null ? ImmutableList.copyOf(deleteResults) : null;

        this.sourceAdGroupIdByCopiedAdGroupId = sourceAdGroupIdByCopiedAdGroupId != null
                ? ImmutableMap.copyOf(sourceAdGroupIdByCopiedAdGroupId)
                : null;
    }

    @Nullable
    public List<AddedKeywordInfo> getAddResults() {
        return addResults;
    }

    @Nullable
    public List<UpdatedKeywordInfo> getUpdateResults() {
        return updateResults;
    }

    @Nullable
    public List<Long> getDeleteResults() {
        return deleteResults;
    }

    @Nullable
    public Map<Long, Long> getSourceAdGroupIdByCopiedAdGroupId() {
        return sourceAdGroupIdByCopiedAdGroupId;
    }
}
