package ru.yandex.direct.core.entity.keyword.container;

import javax.annotation.ParametersAreNonnullByDefault;

import static com.google.common.base.Preconditions.checkNotNull;

@ParametersAreNonnullByDefault
public class KeywordsModifyOperationParams {
    private final boolean autoPrices;

    private KeywordsModifyOperationParams(boolean autoPrices) {
        this.autoPrices = autoPrices;
    }

    public static Builder builder() {
        return new Builder();
    }

    /**
     * @return {@code true}, если включен режим вычисления недостающих ставок в условиях показов.
     */
    public boolean isAutoPrices() {
        return autoPrices;
    }

    public static final class Builder {
        private Boolean autoPrices;

        /**
         * Включает режим автоматического вычисления недостающих ставок в
         * условиях показов (не только фраз). Если этот флаг выставлен в
         * {@code true}, параметр {@code showConditionAutoPriceParams}
         * конструктора операции должен быть не {@code null}.
         * См. {@link ru.yandex.direct.core.entity.keyword.service.KeywordsModifyOperation}
         */
        public Builder withAutoPrices(boolean autoPrices) {
            this.autoPrices = autoPrices;
            return this;
        }

        public KeywordsModifyOperationParams build() {
            checkNotNull(autoPrices, "autoPrices must be specified");

            return new KeywordsModifyOperationParams(autoPrices);
        }
    }
}
