package ru.yandex.direct.core.entity.keyword.container;

import javax.annotation.ParametersAreNonnullByDefault;

import static com.google.common.base.Preconditions.checkNotNull;
import static com.google.common.base.Preconditions.checkState;

@ParametersAreNonnullByDefault
public class KeywordsUpdateOperationParams {
    private final boolean unglueEnabled;
    private final boolean autoPrices;
    //Менять ли фразу и идентификатор кейворда при обновлении, подразумевает unglueEnabled=false
    private final boolean phraseModificationDisabled;

    private KeywordsUpdateOperationParams(boolean unglueEnabled, boolean autoPrices,
            boolean phraseModificationDisabled)
    {
        this.unglueEnabled = unglueEnabled;
        this.autoPrices = autoPrices;
        this.phraseModificationDisabled = phraseModificationDisabled;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isUnglueEnabled() {
        return unglueEnabled;
    }

    /**
     * @return {@code true}, если нужно пересчитывать ставки при изменении фразы
     */
    public boolean isAutoPrices() {
        return autoPrices;
    }

    public boolean isPhraseModificationDisabled() {
        return phraseModificationDisabled;
    }

    public static final class Builder {
        private Boolean unglueEnabled;
        private Boolean autoPrices;
        private Boolean phraseModificationDisabled;

        public Builder withUnglueEnabled(boolean unglueEnabled) {
            this.unglueEnabled = unglueEnabled;
            return this;
        }

        /**
         * Включает режим пересчитывания ставок у измененных фраз,
         * см. коммент к классу {@link ru.yandex.direct.core.entity.keyword.service.KeywordsUpdateOperation}
         * Если включить этот режим, параметр {@code fixedAutoPrices} конструктора
         * операции должен быть не {@code null}
         */
        public Builder withAutoPrices(boolean autoPrices) {
            this.autoPrices = autoPrices;
            return this;
        }

        public Builder withModificationDisabled(boolean phraseModificationDisabled) {
            this.phraseModificationDisabled = phraseModificationDisabled;
            return this;
        }

        public KeywordsUpdateOperationParams build() {
            checkNotNull(unglueEnabled, "unglueEnabled must be specified");
            checkNotNull(autoPrices, "autoPrices must be specified");
            checkNotNull(phraseModificationDisabled, "phraseModificationDisabled must be specified");
            if (phraseModificationDisabled)
                checkState(!unglueEnabled, "unglue should be disabled while phrase modification is disabled");

            return new KeywordsUpdateOperationParams(unglueEnabled, autoPrices, phraseModificationDisabled);
        }
    }
}
