package ru.yandex.direct.core.entity.keyword.container;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

import ru.yandex.direct.bshistory.History;

public class PhraseIdHistoryInfo {
    private BigInteger phraseId;
    private History oldHistory;
    private Long orderId;
    private Long adGroupId;
    private Map<Long, Long> adGroupBanners = new HashMap<>();
    private Map<Long, Long> adGroupImageBanners = new HashMap<>();

    public BigInteger getPhraseId() {
        return phraseId;
    }

    public History getOldHistory() {
        return oldHistory;
    }

    public Long getOrderId() {
        return orderId;
    }

    public Long getAdGroupId() {
        return adGroupId;
    }

    public Map<Long, Long> getAdGroupBanners() {
        return adGroupBanners;
    }

    public Map<Long, Long> getAdGroupImageBanners() {
        return adGroupImageBanners;
    }

    public PhraseIdHistoryInfo withPhraseId(BigInteger phraseId) {
        this.phraseId = phraseId;
        return this;
    }

    public PhraseIdHistoryInfo withOldHistory(History oldHistory) {
        this.oldHistory = oldHistory;
        return this;
    }

    public PhraseIdHistoryInfo withOrderId(Long orderId) {
        this.orderId = orderId;
        return this;
    }

    public PhraseIdHistoryInfo withAdGroupId(Long adGroupId) {
        this.adGroupId = adGroupId;
        return this;
    }

    public PhraseIdHistoryInfo withAdGroupBanners(Map<Long, Long> adGroupBanners) {
        this.adGroupBanners = adGroupBanners;
        return this;
    }

    public PhraseIdHistoryInfo withAdGroupImageBanners(Map<Long, Long> adGroupImageBanners) {
        this.adGroupImageBanners = adGroupImageBanners;
        return this;
    }
}
