package ru.yandex.direct.core.entity.keyword.container;

import java.util.List;

public class UpdatedKeywordInfo {

    private Long id;
    private boolean deleted;

    /**
     * Фраза, получившаяся в результате после всех обработок (не в нормальной форме).
     */
    private String resultPhrase;

    /**
     * Фраза перед добавлением к ней минус-слов в процессе расклейки.
     * Присутствует только для обновленных фраз (deleted = false).
     */
    private String phraseBeforeUnglue;

    /**
     * Описание фиксаций стоп-слов.
     * Может быть равно null, если стоп-слова не были зафиксированы.
     */
    private List<StopwordsFixation> fixations;

    /**
     * Добавленные в результате расклейки минус-слова.
     * Может быть равно null, если минус-слова не были добавлены.
     */
    private List<String> addedMinuses;

    /**
     * остановлена ли фраза. Нужно для передачи в интерфейс
     */
    private Boolean isSuspended;

    public Long getId() {
        return id;
    }

    public UpdatedKeywordInfo withId(Long id) {
        this.id = id;
        return this;
    }

    public boolean isDeleted() {
        return deleted;
    }

    public UpdatedKeywordInfo withDeleted(boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    public String getResultPhrase() {
        return resultPhrase;
    }

    public UpdatedKeywordInfo withResultPhrase(String resultPhrase) {
        this.resultPhrase = resultPhrase;
        return this;
    }

    public String getPhraseBeforeUnglue() {
        return phraseBeforeUnglue;
    }

    public UpdatedKeywordInfo withPhraseBeforeUnglue(String phraseBeforeUnglue) {
        this.phraseBeforeUnglue = phraseBeforeUnglue;
        return this;
    }

    public List<StopwordsFixation> getFixations() {
        return fixations;
    }

    public UpdatedKeywordInfo withFixations(
            List<StopwordsFixation> fixations) {
        this.fixations = fixations;
        return this;
    }

    public List<String> getAddedMinuses() {
        return addedMinuses;
    }

    public UpdatedKeywordInfo withAddedMinuses(List<String> addedMinuses) {
        this.addedMinuses = addedMinuses;
        return this;
    }

    public Boolean getIsSuspended() {
        return isSuspended;
    }

    public UpdatedKeywordInfo withIsSuspended(Boolean isSuspended) {
        this.isSuspended = isSuspended;
        return this;
    }
}
