package ru.yandex.direct.core.entity.keyword.processing;

import java.util.List;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;

import ru.yandex.direct.libs.keywordutils.inclusion.model.SingleKeywordWithLemmas;

public class KeywordCombinator {

    /**
     * Получение всех комбинаций словосочетаний с учетом лемматизации в виде хэшей
     */
    public static IntSet combineAllLemmas(List<SingleKeywordWithLemmas> keywordWithLemmas) {
        if (keywordWithLemmas.isEmpty()) {
            return IntSets.singleton(1);
        }
        IntSet subCombineResult = combineAllLemmas(keywordWithLemmas.subList(1, keywordWithLemmas.size()));
        List<String> firstWordLemmas = keywordWithLemmas.get(0).getLemmas();
        IntSet combineResult = new IntOpenHashSet(firstWordLemmas.size() * subCombineResult.size());
        for (String firstWordLemma : firstWordLemmas) {
            int firstHashCode = firstWordLemma.hashCode();
            for (int keywordCombinationHash : subCombineResult) {
                combineResult.add(31 * keywordCombinationHash + firstHashCode);
            }
        }
        return combineResult;
    }
}
