package ru.yandex.direct.core.entity.keyword.processing;

import java.util.Objects;

import ru.yandex.direct.libs.keywordutils.model.AnyKeyword;

import static ru.yandex.direct.utils.CommonUtils.nvl;

/**
 * Контейнер для хранения связки (исходное слово, нормализованное слово).
 */
public class NormalizedWord<T extends AnyKeyword> implements Comparable<NormalizedWord<T>> {

    private T originalWord;

    private T normalizedWord;

    public NormalizedWord(T normalizedWord) {
        this(null, normalizedWord);
    }

    public NormalizedWord(T originalWord, T normalizedWord) {
        this.originalWord = originalWord;
        this.normalizedWord = normalizedWord;
    }

    public T getOriginalWord() {
        return nvl(originalWord, normalizedWord);
    }

    public T getNormalizedWord() {
        return normalizedWord;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        NormalizedWord that = (NormalizedWord) o;
        return Objects.equals(normalizedWord, that.normalizedWord);
    }

    @Override
    public int hashCode() {
        return Objects.hash(normalizedWord);
    }

    @Override
    public int compareTo(NormalizedWord<T> o) {
        return normalizedWord.compareTo(o.normalizedWord);
    }
}
