package ru.yandex.direct.core.entity.keyword.processing;

import java.math.BigInteger;
import java.util.Comparator;

import ru.yandex.direct.core.entity.keyword.model.Keyword;

/**
 * Сортировка по признакам в порядке приоритета:
 * наличие статистики (PhraseBsId > 0) (сначала PhraseBsId > 0), id фразы (по возрастанию).
 */
public class PhraseIdAndKeywordIdComparator implements Comparator<Keyword> {

    @Override
    public int compare(Keyword keyword1, Keyword keyword2) {
        BigInteger phraseBsId1 = keyword1.getPhraseBsId();
        BigInteger phraseBsId2 = keyword2.getPhraseBsId();
        Long keywordId1 = keyword1.getId();
        Long keywordId2 = keyword2.getId();

        //если у обеих фраз phraseBsId = 0 или у обеих фраз phraseBsId != 0 -> тогда сортируем по id фразы
        if ((phraseBsId1.equals(BigInteger.ZERO) && phraseBsId2.equals(BigInteger.ZERO)) ||
                !(phraseBsId1.equals(BigInteger.ZERO) || phraseBsId2.equals(BigInteger.ZERO))) {
            return keywordId1.compareTo(keywordId2);
        }
        //сортируем в обратном порядке phraseBsId, чтобы phraseBsId = 0 остались в конце списка
        return phraseBsId2.compareTo(phraseBsId1);
    }

}
