package ru.yandex.direct.core.entity.keyword.processing;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.libs.keywordutils.model.KeywordWithMinuses;

/**
 * Связка между исходной ключевой фразой и обработанной.
 */
@ParametersAreNonnullByDefault
public class ProcessedKeyword {

    private KeywordWithMinuses before;
    private KeywordWithMinuses after;

    public ProcessedKeyword(KeywordWithMinuses before, KeywordWithMinuses after) {
        this.after = after;
        this.before = before;
    }

    /**
     * @return Исходное ключевое слово, участвовавшее в обработке
     */
    public KeywordWithMinuses getBefore() {
        return before;
    }

    /**
     * @return Ключевое слово после обработки
     */
    public KeywordWithMinuses getAfter() {
        return after;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProcessedKeyword that = (ProcessedKeyword) o;
        return Objects.equals(before, that.before) &&
                Objects.equals(after, that.after);
    }

    @Override
    public int hashCode() {
        return Objects.hash(before, after);
    }
}
