package ru.yandex.direct.core.entity.keyword.processing;

import java.util.Comparator;

import ru.yandex.direct.libs.keywordutils.inclusion.model.SingleKeywordWithLemmas;

public class SingleKeywordByFirstLemmaComparator implements Comparator<SingleKeywordWithLemmas> {

    @Override
    public int compare(SingleKeywordWithLemmas singleKeyword1, SingleKeywordWithLemmas singleKeyword2) {
        String word1Lemma = singleKeyword1.getLemmas().iterator().next();
        String word2Lemma = singleKeyword2.getLemmas().iterator().next();
        return word1Lemma.compareTo(word2Lemma);
    }
}
