package ru.yandex.direct.core.entity.keyword.processing.bsexport

import com.google.common.base.CharMatcher
import com.google.common.base.Splitter
import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.stopword.service.StopWordService

@Component
open class BsExportTextProcessor constructor(
    private val stopWordService: StopWordService
) {
    val WHITESPACE_SPLITTER = Splitter.on(CharMatcher.whitespace())

    /**
     * ФОрматирование текста для отправки в БК
     *
     * Аналог Yandex::StopWords::process_quoted_phrases
     */
    fun processQuotedText(phrase: String): String {
        var ret = phrase.trim()
        if (ret.startsWith('"') && ret.endsWith('"')) {
            ret = ret.substring(1, ret.length - 1)
            return WHITESPACE_SPLITTER.split(ret)
                .filter { it.isNotEmpty() }
                .map {
                    if (
                        stopWordService.isStopWord(it, false)
                        && !it.startsWith('!')
                        && !it.startsWith('+')
                    )
                        "+$it"
                    else
                        it

                }
                .joinToString(" ") + " ~0"
        } else {
            return ret
        }
    }
}
