package ru.yandex.direct.core.entity.keyword.processing.deduplication;

import ru.yandex.direct.libs.keywordutils.model.KeywordWithMinuses;

import static java.util.Objects.requireNonNull;

public class DuplicatingContainer {

    private final Integer index;
    private final Integer adGroupIndex;
    private final KeywordWithMinuses normalizedKeywordWithMinuses;
    private final Boolean isAutotargeting;

    public DuplicatingContainer(Integer index, Integer adGroupIndex,
                                KeywordWithMinuses normalizedKeywordWithMinuses,
                                Boolean isAutotargeting) {
        this.index = requireNonNull(index);
        this.adGroupIndex = requireNonNull(adGroupIndex);
        this.normalizedKeywordWithMinuses = requireNonNull(normalizedKeywordWithMinuses);
        this.isAutotargeting = isAutotargeting;
    }

    public Integer getIndex() {
        return index;
    }

    public Integer getAdGroupIndex() {
        return adGroupIndex;
    }

    public KeywordWithMinuses getNormalizedKeywordWithMinuses() {
        return normalizedKeywordWithMinuses;
    }

    public Boolean getAutotargeting() {
        return isAutotargeting;
    }
}
