package ru.yandex.direct.core.entity.keyword.processing.deduplication;

import ru.yandex.direct.libs.keywordutils.model.Keyword;
import ru.yandex.direct.libs.keywordutils.model.KeywordWithMinuses;

public class KeywordDeduplicationUtils {

    private KeywordDeduplicationUtils() {
    }

    /**
     * @param thisKeyword  нормализованная фраза
     * @param otherKeyword другая нормализованная фраза
     * @return являются ли две фразы дубликатами
     */
    public static boolean checkDuplication(Keyword thisKeyword, Keyword otherKeyword) {
        // если только одна из фраз в кавычках, то данная не может быть дубликатом другой
        if (otherKeyword.isQuoted() && !thisKeyword.isQuoted()
                || !otherKeyword.isQuoted() && thisKeyword.isQuoted()) {
            return false;
        }

        // для начала проверяем размеры - самый дешевый путь
        if (otherKeyword.getAllKeywords().size() != thisKeyword.getAllKeywords().size()) {
            return false;
        }

        return thisKeyword.toString().equals(otherKeyword.toString());
    }

    /**
     * !Минус фразы должны быть сортированы
     *
     * @param thisKeywordWithMinuses  нормализованная фраза с нормализованными минус фразами
     * @param otherKeywordWithMinuses нормализованная фраза с нормализованными минус фразами
     * @return являются ли две фразы дубликатами
     */
    public static boolean checkDuplication(KeywordWithMinuses thisKeywordWithMinuses,
                                           KeywordWithMinuses otherKeywordWithMinuses) {
        if (otherKeywordWithMinuses.getMinusKeywords().size() != thisKeywordWithMinuses.getMinusKeywords().size()) {
            return false;
        }
        boolean isKeywordDuplicate = KeywordDeduplicationUtils
                .checkDuplication(thisKeywordWithMinuses.getKeyword(), otherKeywordWithMinuses.getKeyword());
        if (!isKeywordDuplicate) {
            return false;
        }

        for (int i = 0; i < otherKeywordWithMinuses.getMinusKeywords().size(); i++) {
            Keyword otherMinusKeyword = otherKeywordWithMinuses.getMinusKeywords().get(i);
            Keyword thisMinusKeyword = thisKeywordWithMinuses.getMinusKeywords().get(i);
            if (!KeywordDeduplicationUtils.checkDuplication(thisMinusKeyword, otherMinusKeyword)) {
                return false;
            }
        }
        return true;
    }
}
