package ru.yandex.direct.core.entity.keyword.processing.unglue;

import ru.yandex.direct.core.entity.keyword.processing.NormalizedKeywordWithMinuses;
import ru.yandex.direct.libs.keywordutils.model.KeywordWithMinuses;

import static java.util.Objects.requireNonNull;

/**
 * Контейнер для передачи фраз в утилиту расклейки.
 */
public class UnglueContainer {

    /**
     * Индекс фразы (индекс, используемый в вызывающем сервисе).
     * Нужен, чтобы матчить полученные результаты с входными данными.
     */
    private final Integer index;

    /**
     * Индекс группы (условный) для линковки групп и фраз (фразы могут быть расклеены, только если они принадлежат одной группе).
     */
    private final Integer adGroupIndex;

    /**
     * Нормализованная ключевая фраза с минус-словами
     * (минус-слова так же должны быть нормализованы и отсортированы).
     */
    private NormalizedKeywordWithMinuses normalizedKeywordWithMinuses;

    public UnglueContainer(Integer index, Integer adGroupIndex, KeywordWithMinuses normalKeywordWithMinuses) {
        this(index, adGroupIndex, NormalizedKeywordWithMinuses.from(normalKeywordWithMinuses));
    }

    public UnglueContainer(Integer index, Integer adGroupIndex, NormalizedKeywordWithMinuses normalizedKeywordWithMinuses) {
        this.index = requireNonNull(index, "index");
        this.adGroupIndex = requireNonNull(adGroupIndex, "adGroupIndex");
        this.normalizedKeywordWithMinuses = requireNonNull(normalizedKeywordWithMinuses, "normalizedKeywordWithMinuses");
    }

    public Integer getIndex() {
        return index;
    }

    public Integer getAdGroupIndex() {
        return adGroupIndex;
    }

    public KeywordWithMinuses getNormalKeywordWithMinuses() {
        return normalizedKeywordWithMinuses.toKeywordWithMinuses();
    }

    public NormalizedKeywordWithMinuses getNormalizedKeywordWithMinuses() {
        return normalizedKeywordWithMinuses;
    }
}
