package ru.yandex.direct.core.entity.keyword.repository;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.keyword.model.FixationPhrase;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.read.JooqReaderWithSupplier;
import ru.yandex.direct.jooqmapper.read.JooqReaderWithSupplierBuilder;

import static ru.yandex.direct.dbschema.ppcdict.tables.StopwordFixation.STOPWORD_FIXATION;
import static ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromField;

@Repository
@ParametersAreNonnullByDefault
public class FixationPhraseRepository {
    private final DslContextProvider dslContextProvider;
    private final JooqReaderWithSupplier<FixationPhrase> stopwordFixationReader;

    @Autowired
    public FixationPhraseRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
        this.stopwordFixationReader = createMapper();
    }

    public List<FixationPhrase> getPhrases() {
        return dslContextProvider.ppcdict()
                .select(stopwordFixationReader.getFieldsToRead())
                .from(STOPWORD_FIXATION)
                .fetch(stopwordFixationReader::fromDb);
    }

    private JooqReaderWithSupplier<FixationPhrase> createMapper() {
        return JooqReaderWithSupplierBuilder.builder(FixationPhrase::new)
                .readProperty(FixationPhrase.PHRASE, fromField(STOPWORD_FIXATION.PHRASE))
                .build();
    }
}
