package ru.yandex.direct.core.entity.keyword.repository;

import java.math.BigDecimal;

import ru.yandex.direct.core.entity.StatusBsSynced;
import ru.yandex.direct.core.entity.keyword.model.StatusModerate;
import ru.yandex.direct.dbschema.ppc.enums.BidsArcStatusbssynced;
import ru.yandex.direct.dbschema.ppc.enums.BidsArcStatusmoderate;
import ru.yandex.direct.dbschema.ppc.enums.BidsArcWarn;
import ru.yandex.direct.dbschema.ppc.enums.BidsStatusbssynced;
import ru.yandex.direct.dbschema.ppc.enums.BidsWarn;

import static ru.yandex.direct.core.entity.keyword.service.KeywordUtils.AUTOTARGETING_PREFIX;
import static ru.yandex.direct.core.entity.keyword.service.KeywordUtils.hasAutotargetingPrefix;
import static ru.yandex.direct.core.entity.keyword.service.KeywordUtils.hasNoAutotargetingPrefix;
import static ru.yandex.direct.core.entity.keyword.service.KeywordUtils.phraseWithoutAutotargetingPrefix;

public class KeywordMapping {
    private KeywordMapping() {
    }

    public static BidsWarn needCheckPlaceModifiedToDbFormat(Boolean needCheckPlaceModified) {
        if (needCheckPlaceModified == null) {
            return null;
        } else if (needCheckPlaceModified) {
            return BidsWarn.Yes;
        } else {
            return BidsWarn.No;
        }
    }

    public static Boolean needCheckPlaceModifiedFromDbFormat(BidsWarn bidsWarn) {
        if (bidsWarn == null) {
            return null;
        } else {
            return bidsWarn.equals(BidsWarn.Yes);
        }
    }

    public static BidsArcWarn needCheckPlaceModifiedToArcDbFormat(Boolean needCheckPlaceModified) {
        if (needCheckPlaceModified == null) {
            return null;
        } else if (needCheckPlaceModified) {
            return BidsArcWarn.Yes;
        } else {
            return BidsArcWarn.No;
        }
    }

    public static Boolean needCheckPlaceModifiedFromDbFormat(BidsArcWarn bidsWarn) {
        if (bidsWarn == null) {
            return null;
        } else {
            return bidsWarn.equals(BidsWarn.Yes);
        }
    }

    public static Boolean isAutotargetingFromDb(String keyword) {
        return hasAutotargetingPrefix(keyword);
    }

    public static String phraseFromDb(String keyword) {
        return phraseWithoutAutotargetingPrefix(keyword);
    }

    public static String phraseToDbFormat(Boolean isAutotargeting, String keyword) {
        return hasNoAutotargetingPrefix(isAutotargeting)
                ? keyword
                : AUTOTARGETING_PREFIX + keyword;
    }

    public static BidsStatusbssynced statusBsSyncedToDbFormat(StatusBsSynced statusBsSynced) {
        return statusBsSynced != null ? BidsStatusbssynced.valueOf(statusBsSynced.toDbFormat()) : null;
    }

    public static StatusBsSynced statusBsSyncedFromDbFormat(BidsStatusbssynced bidsStatusbssynced) {
        return bidsStatusbssynced != null ? StatusBsSynced.valueOfDbFormat(bidsStatusbssynced.toString()) : null;
    }

    public static BidsArcStatusbssynced statusBsSyncedToArcDbFormat(StatusBsSynced statusBsSynced) {
        return statusBsSynced != null ? BidsArcStatusbssynced.valueOf(statusBsSynced.toDbFormat()) : null;
    }

    public static StatusBsSynced statusBsSyncedFromDbFormat(BidsArcStatusbssynced bidsStatusbssynced) {
        return bidsStatusbssynced != null ? StatusBsSynced.valueOfDbFormat(bidsStatusbssynced.toString()) : null;
    }


    public static BigDecimal priceToDbFormat(BigDecimal price) {
        return price == null ? BigDecimal.ZERO : price;
    }

    public static BigDecimal priceFromDbFormat(BigDecimal price) {
        return price == null || price.compareTo(BigDecimal.ZERO) == 0 ? null : price;
    }

    public static BidsArcStatusmoderate statusModerateToArcDbFormat(StatusModerate statusModerate) {
        if (statusModerate == null) {
            return null;
        }
        switch (statusModerate) {
            case NEW:
                return BidsArcStatusmoderate.New;
            case YES:
                return BidsArcStatusmoderate.Yes;
            case NO:
                return BidsArcStatusmoderate.No;
            default:
                throw new IllegalStateException("No such value: " + statusModerate);
        }
    }

    public static StatusModerate statusModerateFromDbFormat(BidsArcStatusmoderate bidsArcStatusmoderate) {
        if (bidsArcStatusmoderate == null) {
            return null;
        }

        switch (bidsArcStatusmoderate) {
            case New:
                return StatusModerate.NEW;
            case Yes:
                return StatusModerate.YES;
            case No:
                return StatusModerate.NO;
            default: throw new IllegalStateException("No such value: " + bidsArcStatusmoderate);
        }
    }
}
