package ru.yandex.direct.core.entity.keyword.service;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.repository.AdGroupRepository;
import ru.yandex.direct.core.entity.adgroup.service.complex.ComplexAdGroupAddOperationFactory;
import ru.yandex.direct.core.entity.adgroup.service.complex.ComplexAdGroupService;
import ru.yandex.direct.core.entity.client.service.ClientGeoService;
import ru.yandex.direct.core.entity.client.service.ClientLimitsService;
import ru.yandex.direct.core.entity.client.service.ClientService;
import ru.yandex.direct.core.entity.keyword.container.KeywordsModificationContainer;
import ru.yandex.direct.core.entity.keyword.container.KeywordsModifyOperationParams;
import ru.yandex.direct.core.entity.keyword.processing.KeywordNormalizer;
import ru.yandex.direct.core.entity.keyword.repository.KeywordRepository;
import ru.yandex.direct.core.entity.showcondition.container.ShowConditionAutoPriceParams;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.rbac.RbacService;

@Component
@ParametersAreNonnullByDefault
public class KeywordModifyOperationFactory {

    private final KeywordOperationFactory keywordOperationFactory;
    private final ComplexAdGroupService complexAdGroupService;
    private final ComplexAdGroupAddOperationFactory complexAdGroupAddOperationFactory;
    private final ClientGeoService clientGeoService;
    private final ClientLimitsService clientLimitsService;
    private final RbacService rbacService;
    private final ClientService clientService;
    private final ShardHelper shardHelper;
    private final KeywordRepository keywordRepository;
    private final KeywordNormalizer keywordNormalizer;
    private final AdGroupRepository adGroupRepository;

    public KeywordModifyOperationFactory(
            KeywordOperationFactory keywordOperationFactory,
            ComplexAdGroupService complexAdGroupService,
            ComplexAdGroupAddOperationFactory complexAdGroupAddOperationFactory,
            ClientGeoService clientGeoService,
            ClientLimitsService clientLimitsService,
            RbacService rbacService, ClientService clientService,
            ShardHelper shardHelper,
            KeywordRepository keywordRepository,
            KeywordNormalizer keywordNormalizer,
            AdGroupRepository adGroupRepository) {
        this.keywordOperationFactory = keywordOperationFactory;
        this.complexAdGroupService = complexAdGroupService;
        this.complexAdGroupAddOperationFactory = complexAdGroupAddOperationFactory;
        this.clientGeoService = clientGeoService;
        this.clientLimitsService = clientLimitsService;
        this.rbacService = rbacService;
        this.clientService = clientService;
        this.shardHelper = shardHelper;
        this.keywordRepository = keywordRepository;
        this.keywordNormalizer = keywordNormalizer;
        this.adGroupRepository = adGroupRepository;
    }

    /**
     * @param showConditionAutoPriceParams параметры для автоматического вычисления недостающих ставок
     *                                     в условиях показов. Должен быть не {@code null}, если в параметрах включен
     *                                     режим {@code autoPrices}.
     *                                     N.B.: это параметры для вычисления ставок не только КФ, но всех условий
     *                                     показа, для случаев, когда происходит копирование группы при переполнении.
     */
    public KeywordsModifyOperation createKeywordsModifyOperation(KeywordsModifyOperationParams operationParams,
                                                                 KeywordsModificationContainer container,
                                                                 @Nullable ShowConditionAutoPriceParams showConditionAutoPriceParams,
                                                                 long operatorUid, ClientId clientId, long clientUid) {
        int shard = shardHelper.getShardByClientIdStrictly(clientId);
        return new KeywordsModifyOperation(operationParams,
                keywordOperationFactory, keywordRepository, keywordNormalizer, adGroupRepository,
                complexAdGroupService, clientLimitsService, clientGeoService, rbacService, clientService,
                complexAdGroupAddOperationFactory, showConditionAutoPriceParams,
                operatorUid, clientId, clientUid, shard, container);
    }

    /**
     * Создание операции изменения КФ без автоматического вычисления
     * недостающих ставок и приоритетов автобюджета. Наличие нужных ставок
     * проверяется валидацией.
     */
    public KeywordsModifyOperation createKeywordsModifyOperation(KeywordsModificationContainer container,
                                                                 long operatorUid, ClientId clientId, long clientUid) {
        int shard = shardHelper.getShardByClientIdStrictly(clientId);

        KeywordsModifyOperationParams operationParams = KeywordsModifyOperationParams.builder()
                .withAutoPrices(false)
                .build();
        return new KeywordsModifyOperation(operationParams, keywordOperationFactory, keywordRepository,
                keywordNormalizer, adGroupRepository, complexAdGroupService, clientLimitsService, clientGeoService,
                rbacService, clientService,
                complexAdGroupAddOperationFactory, null,
                operatorUid, clientId, clientUid, shard, container);
    }
}
