package ru.yandex.direct.core.entity.keyword.service;

import java.util.Collection;
import java.util.Map;

import ru.yandex.direct.core.entity.keyword.model.Keyword;
import ru.yandex.direct.core.entity.keyword.model.KeywordRecentStatistics;

/**
 * Интерфейс для получения статистики показов по фразам
 */
public interface KeywordRecentStatisticsProvider {
    /**
     * @param keywordRequests коллекция фраз, по которой нужно получить статистику показов
     * @return мапа со статистикой показов по директовскому Id фразы
     */
    Map<Long, KeywordRecentStatistics> getKeywordRecentStatistics(
            Collection<Keyword> keywordRequests);
}
