package ru.yandex.direct.core.entity.keyword.service.internal;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.keyword.container.InternalKeyword;
import ru.yandex.direct.core.entity.keyword.model.Keyword;
import ru.yandex.direct.core.entity.keyword.processing.KeywordNormalizer;
import ru.yandex.direct.libs.keywordutils.model.KeywordWithMinuses;

import static ru.yandex.direct.core.entity.keyword.service.KeywordUtils.safeParseWithMinuses;

@ParametersAreNonnullByDefault
@Service
public class InternalKeywordFactory {

    private KeywordNormalizer keywordNormalizer;

    public InternalKeywordFactory(KeywordNormalizer keywordNormalizer) {
        this.keywordNormalizer = keywordNormalizer;
    }

    /**
     * Парсит и нормализует фразу {@code keyword}.
     * Если не удалось распарсить фразу, возвращает {@code null}
     */
    @Nullable
    public InternalKeyword createInternalKeyword(Keyword keyword) {
        KeywordWithMinuses rawKeyword = safeParseWithMinuses(keyword.getPhrase());
        if (rawKeyword == null) {
            return null;
        }
        KeywordWithMinuses normalizedKeyword = keywordNormalizer.normalizeKeywordWithMinuses(rawKeyword);
        return new InternalKeyword(keyword, rawKeyword, normalizedKeyword);
    }
}
